/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.spring;

import java.beans.PropertyEditorSupport;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.JavaScriptUtils;

public class StringEscapeEditor
extends PropertyEditorSupport {
    private boolean escapeHTML;
    private boolean escapeJavaScript;

    public StringEscapeEditor() {
    }

    public StringEscapeEditor(boolean escapeHTML, boolean escapeJavaScript) {
        this.escapeHTML = escapeHTML;
        this.escapeJavaScript = escapeJavaScript;
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        return value.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue("");
        } else {
            String value = text.trim();
            if (this.escapeHTML) {
                value = HtmlUtils.htmlEscape((String)value);
            }
            if (this.escapeJavaScript) {
                value = JavaScriptUtils.javaScriptEscape((String)value);
            }
            this.setValue(value);
        }
    }
}

