/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.spring;

import java.io.IOException;
import java.util.Map;
import jmind.core.log.LogUtil;
import jmind.core.spring.BeanLocator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;
import org.xml.sax.EntityResolver;

public class SpringBeanLocator
implements ApplicationContextAware,
BeanLocator {
    private static final SpringBeanLocator INSTANCE = new SpringBeanLocator();
    private ConfigurableApplicationContext context;

    public static SpringBeanLocator getInstance() {
        return INSTANCE;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = (ConfigurableApplicationContext)context;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    @Override
    public <T> T getBean(Class<T> requiredType) {
        return (T)this.context.getBean(requiredType);
    }

    @Override
    public <T> T getBean(String beanName) {
        return (T)this.context.getBean(beanName);
    }

    public <T> T getBean(String name, Class<T> requiredType) {
        return (T)this.context.getBean(name, requiredType);
    }

    @Override
    public boolean containsBean(String name) {
        if (this.context == null) {
            return false;
        }
        return this.context.containsBean(name);
    }

    public <T> String[] getBeanNames(Class<T> clazz) {
        return this.context.getBeanNamesForType(clazz);
    }

    public <T> Map<String, T> getBeans(Class<T> clazz) {
        return this.context.getBeansOfType(clazz);
    }

    public void loadConfig(String ... configLocationString) {
        XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.context.getBeanFactory());
        beanDefinitionReader.setResourceLoader((ResourceLoader)this.context);
        beanDefinitionReader.setEntityResolver((EntityResolver)new ResourceEntityResolver((ResourceLoader)this.context));
        try {
            LogUtil.debug("dynamic load {}", configLocationString);
            for (String configLocation : configLocationString) {
                beanDefinitionReader.loadBeanDefinitions(this.context.getResources(configLocation));
            }
        }
        catch (BeansException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadPackages(String ... packages) {
        XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.context.getBeanFactory());
        beanDefinitionReader.setResourceLoader((ResourceLoader)this.context);
        beanDefinitionReader.setEntityResolver((EntityResolver)new ResourceEntityResolver((ResourceLoader)this.context));
        StandardEnvironment environment = new StandardEnvironment();
        for (String pg : packages) {
            String path = ClassUtils.convertClassNameToResourcePath((String)environment.resolveRequiredPlaceholders(pg)) + "/**/*.class";
            try {
                beanDefinitionReader.loadBeanDefinitions(this.context.getResources(path));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void loadBean(Class<?> clazz) {
        BeanDefinitionBuilder userBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        DefaultListableBeanFactory acf = (DefaultListableBeanFactory)this.context.getAutowireCapableBeanFactory();
        acf.registerBeanDefinition(clazz.getName(), (BeanDefinition)userBeanDefinitionBuilder.getRawBeanDefinition());
    }

    @Override
    public void loadBean(Class<?> clazz, Map<String, Object> props) {
        BeanDefinitionBuilder userBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            userBeanDefinitionBuilder.addPropertyValue(entry.getKey(), entry.getValue());
        }
        DefaultListableBeanFactory acf = (DefaultListableBeanFactory)this.context.getAutowireCapableBeanFactory();
        acf.registerBeanDefinition(clazz.getName(), (BeanDefinition)userBeanDefinitionBuilder.getRawBeanDefinition());
    }

    @Override
    public void removeBean(String name) {
        DefaultListableBeanFactory acf = (DefaultListableBeanFactory)this.context.getAutowireCapableBeanFactory();
        if (acf.containsBean(name)) {
            acf.removeBeanDefinition(name);
        }
    }

    public void publishEvent(ApplicationEvent event) {
        this.context.publishEvent(event);
    }

    public void addApplicationListener(ApplicationListener<?> listener) {
        this.context.addApplicationListener(listener);
    }
}

