/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.spring;

import java.util.Map;
import jmind.core.spring.BeanLocator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class SpringBeanFactoryLocator
implements BeanFactoryAware,
BeanLocator {
    private static final SpringBeanFactoryLocator SPRINGBEANLOCATOR = new SpringBeanFactoryLocator();
    private BeanFactory beanFactory;

    @Override
    public <T> T getBean(Class<T> clazz) {
        return (T)this.beanFactory.getBean(clazz);
    }

    @Override
    public boolean containsBean(String name) {
        return this.beanFactory.containsBean(name);
    }

    @Override
    public <T> T getBean(String beanName) {
        return (T)this.beanFactory.getBean(beanName);
    }

    public <T> T getBean(String beanName, Class<T> clazz) {
        return (T)this.beanFactory.getBean(beanName, clazz);
    }

    public static SpringBeanFactoryLocator getInstance() {
        return SPRINGBEANLOCATOR;
    }

    private SpringBeanFactoryLocator() {
    }

    public DefaultListableBeanFactory getBeanFactory() {
        return (DefaultListableBeanFactory)this.beanFactory;
    }

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.beanFactory = factory;
    }

    @Override
    public void loadBean(Class<?> clazz) {
        BeanDefinitionBuilder userBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        this.getBeanFactory().registerBeanDefinition(clazz.getName(), (BeanDefinition)userBeanDefinitionBuilder.getRawBeanDefinition());
    }

    @Override
    public void removeBean(String name) {
        if (this.beanFactory.containsBean(name)) {
            this.getBeanFactory().removeBeanDefinition(name);
        }
    }

    @Override
    public void loadBean(Class<?> clazz, Map<String, Object> props) {
        BeanDefinitionBuilder userBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            userBeanDefinitionBuilder.addPropertyValue(entry.getKey(), entry.getValue());
        }
        this.getBeanFactory().registerBeanDefinition(clazz.getName(), (BeanDefinition)userBeanDefinitionBuilder.getRawBeanDefinition());
    }
}

