/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.spring;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringBeanFactory {
    private static SpringBeanFactory instance;
    private ClassPathXmlApplicationContext context;

    public static SpringBeanFactory getInstance() {
        if (instance == null) {
            instance = new SpringBeanFactory();
        }
        return instance;
    }

    private SpringBeanFactory() {
        this.context = new ClassPathXmlApplicationContext("spring.xml");
    }

    public SpringBeanFactory(String ... name) {
        this.context = new ClassPathXmlApplicationContext(name);
        this.context.start();
    }

    public <T> T getBean(Class<T> clazz) {
        return (T)this.context.getBean(clazz);
    }

    public <T> T getBean(String name, Class<T> clazz) {
        return (T)this.context.getBean(name, clazz);
    }

    public Object getBean(String name) {
        return this.context.getBean(name);
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    protected void finalize() throws Throwable {
        this.context = null;
        System.out.println(this.getClass().getSimpleName() + " finalize");
        super.finalize();
    }
}

