/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.spring;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class ShineContextLoaderListener
extends ContextLoaderListener {
    private ContextLoader contextLoader;

    protected WebApplicationContext createWebApplicationContext(ServletContext sc, ApplicationContext parent) {
        Class contextClass = this.determineContextClass(sc);
        if (!ConfigurableWebApplicationContext.class.isAssignableFrom(contextClass)) {
            throw new ApplicationContextException("Custom context class [" + contextClass.getName() + "] is not of type [" + ConfigurableWebApplicationContext.class.getName() + "]");
        }
        ConfigurableWebApplicationContext wac = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass((Class)contextClass);
        if (sc.getMajorVersion() == 2 && sc.getMinorVersion() < 5) {
            String servletContextName = sc.getServletContextName();
            wac.setId(ConfigurableWebApplicationContext.APPLICATION_CONTEXT_ID_PREFIX + ObjectUtils.getDisplayString((Object)servletContextName));
        } else {
            try {
                String contextPath = (String)ServletContext.class.getMethod("getContextPath", new Class[0]).invoke((Object)sc, new Object[0]);
                wac.setId(ConfigurableWebApplicationContext.APPLICATION_CONTEXT_ID_PREFIX + ObjectUtils.getDisplayString((Object)contextPath));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to invoke Servlet 2.5 getContextPath method", ex);
            }
        }
        String configLocation = sc.getInitParameter("contextConfigLocation");
        String fusionConfigLocation = "";
        wac.setParent(parent);
        wac.setServletContext(sc);
        wac.setConfigLocation(fusionConfigLocation);
        this.customizeContext(sc, wac);
        wac.refresh();
        return wac;
    }

    public void contextInitialized(ServletContextEvent event) {
        if (this.contextLoader == null) {
            this.contextLoader = this;
        }
        this.contextLoader.initWebApplicationContext(event.getServletContext());
    }
}

