/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.spring;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import jmind.core.log.LogUtil;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.FileCopyUtils;

public class MappingFastjsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    public static final MediaType DEFAULT_TYPE = new MediaType("text", "plain", Charset.forName("UTF-8"));

    public MappingFastjsonHttpMessageConverter() {
        super(new MediaType[]{DEFAULT_TYPE, MediaType.ALL});
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return true;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return true;
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        String param = FileCopyUtils.copyToString((Reader)new InputStreamReader(inputMessage.getBody(), "UTF-8"));
        param = URLDecoder.decode(param, "UTF-8");
        LogUtil.debug("MappingFastjsonHttpMessageConverter  clazz={},body= {}", clazz, param);
        if (clazz.equals(String.class)) {
            return param;
        }
        if (param.startsWith("{") && param.endsWith("}")) {
            return JSON.parseObject((String)param, clazz);
        }
        if (param.contains("=")) {
            String[] split;
            JSONObject jo = new JSONObject();
            for (String s : split = param.split("&")) {
                String[] ss = s.split("=");
                if (ss.length != 2) continue;
                jo.put(ss[0], (Object)ss[1]);
            }
            if (!jo.isEmpty()) {
                return JSON.toJavaObject((JSON)jo, clazz);
            }
        }
        return JSON.parseObject((String)param, clazz);
    }

    protected void writeInternal(Object t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        outputMessage.getHeaders().setContentType(DEFAULT_TYPE);
        if (t == null) {
            return;
        }
        if (t instanceof String) {
            FileCopyUtils.copy((String)((String)t), (Writer)new OutputStreamWriter(outputMessage.getBody(), "UTF-8"));
        } else {
            String s = JSON.toJSONString((Object)t, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat});
            FileCopyUtils.copy((String)s, (Writer)new OutputStreamWriter(outputMessage.getBody(), "UTF-8"));
        }
    }
}

