/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.spring;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class FastJsonHttpMessageConverter
extends AbstractGenericHttpMessageConverter<Object> {
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    public FastJsonHttpMessageConverter() {
        super(MediaType.ALL);
    }

    protected boolean supports(Class<?> paramClass) {
        return true;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return true;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return true;
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        InputStream in = inputMessage.getBody();
        return JSON.parseObject((InputStream)in, (Charset)this.fastJsonConfig.getCharset(), (Type)type, (Feature[])this.fastJsonConfig.getFeatures());
    }

    protected void writeInternal(Object obj, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (obj == null) {
            return;
        }
        HttpHeaders headers = outputMessage.getHeaders();
        if (type.equals(String.class)) {
            String s = (String)obj;
            headers.setContentLength((long)s.length());
            OutputStream out = outputMessage.getBody();
            out.write(s.getBytes(this.fastJsonConfig.getCharset()));
            out.flush();
        } else {
            ByteArrayOutputStream outnew = new ByteArrayOutputStream();
            int len = JSON.writeJSONString((OutputStream)outnew, (Charset)this.fastJsonConfig.getCharset(), (Object)obj, (SerializeConfig)this.fastJsonConfig.getSerializeConfig(), (SerializeFilter[])this.fastJsonConfig.getSerializeFilters(), (String)this.fastJsonConfig.getDateFormat(), (int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature[])this.fastJsonConfig.getSerializerFeatures());
            headers.setContentLength((long)len);
            OutputStream out = outputMessage.getBody();
            outnew.writeTo(out);
            outnew.close();
        }
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        InputStream in = inputMessage.getBody();
        return JSON.parseObject((InputStream)in, (Charset)this.fastJsonConfig.getCharset(), clazz, (Feature[])this.fastJsonConfig.getFeatures());
    }
}

