/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.redis;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;
import jmind.core.redis.AbstractJedis;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisCommands;

public class RedisCluster
extends AbstractJedis {
    JedisCluster jc;

    public RedisCluster(String name, IProperties p) {
        String[] hostAndPort = p.getProperty("redis." + name + ".host").split(",");
        HashSet<HostAndPort> jedisClusterNodesSet = new HashSet<HostAndPort>();
        for (String hp : hostAndPort) {
            String[] hap = hp.split(":");
            jedisClusterNodesSet.add(new HostAndPort(hap[0], Integer.parseInt(hap[1])));
        }
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxIdle(DataUtil.toInt((String)p.getProperty("redis." + name + ".maxIdle", "10")));
        genericObjectPoolConfig.setMaxTotal(DataUtil.toInt((String)p.getProperty("redis." + name + ".maxTotal", "10")));
        genericObjectPoolConfig.setMinIdle(DataUtil.toInt((String)p.getProperty("redis." + name + ".minIdle")));
        String password = p.getProperty("redis." + name + ".password");
        int timeout = DataUtil.toInt((String)p.getProperty("redis." + name + ".timeout", "3")) * 1000;
        this.jc = DataUtil.isEmpty((String)password) ? new JedisCluster(jedisClusterNodesSet, timeout, DataUtil.toInt((String)p.getProperty("redis." + name + ".maxRedirections", "5")), genericObjectPoolConfig) : new JedisCluster(jedisClusterNodesSet, timeout, timeout, DataUtil.toInt((String)p.getProperty("redis." + name + ".maxRedirections", "5")), password, genericObjectPoolConfig);
    }

    @Override
    public void releaseResource() {
        try {
            this.jc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close(Object resource) {
    }

    @Override
    public long del(String ... keys) {
        return this.jc.del(keys);
    }

    @Override
    public List<String> mget(String ... key) {
        return this.jc.mget(key);
    }

    @Override
    public JedisCommands getResource() {
        return this.jc;
    }
}

