/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.redis;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jmind.base.lang.ScoreValue;
import jmind.base.lang.shard.LoadBalance;
import jmind.core.redis.Redis;
import jmind.redis.RedisBootstrap;
import jmind.redis.RedisCmd;

public class NioRedis
implements Redis {
    private final RedisCmd<String, String> c;
    private final RedisBootstrap bootstarp;

    public NioRedis(String hosts, int timeout) {
        this.bootstarp = new RedisBootstrap(hosts, timeout);
        this.c = this.bootstarp.connectAsync();
    }

    public NioRedis(String hosts, int timeout, LoadBalance.Balance balance) {
        this.bootstarp = new RedisBootstrap(hosts, timeout);
        this.c = this.bootstarp.connectAsync(balance);
    }

    @Override
    public long del(String ... keys) {
        return this.c.del((Object[])keys);
    }

    @Override
    public String set(String key, String value) {
        return (String)this.c.await(this.c.set((Object)key, (Object)value));
    }

    @Override
    public String get(String key) {
        return (String)this.c.await(this.c.get((Object)key));
    }

    @Override
    public List<String> mget(String ... keys) {
        return this.c.mget((Object[])keys);
    }

    @Override
    public Boolean exists(String key) {
        return (Boolean)this.c.await(this.c.exists((Object)key));
    }

    @Override
    public String type(String key) {
        return (String)this.c.await(this.c.type((Object)key));
    }

    @Override
    public boolean expire(String key, int seconds) {
        return (Boolean)this.c.await(this.c.expire((Object)key, seconds));
    }

    @Override
    public boolean expireAt(String key, long unixTime) {
        return (Boolean)this.c.await(this.c.expireat((Object)key, unixTime));
    }

    @Override
    public Long ttl(String key) {
        return (Long)this.c.await(this.c.ttl((Object)key));
    }

    @Override
    public Long setbit(String key, long offset, int value) {
        return (Long)this.c.await(this.c.setbit((Object)key, offset, value));
    }

    @Override
    public Long getbit(String key, long offset) {
        return (Long)this.c.await(this.c.getbit((Object)key, offset));
    }

    @Override
    public Long setrange(String key, long offset, String value) {
        return (Long)this.c.await(this.c.setrange((Object)key, offset, (Object)value));
    }

    @Override
    public String getrange(String key, long start, long end) {
        return (String)this.c.await(this.c.getrange((Object)key, start, end));
    }

    @Override
    public String getSet(String key, String value) {
        return (String)this.c.await(this.c.getset((Object)key, (Object)value));
    }

    @Override
    public Long setnx(String key, String value) {
        return (Long)this.c.await(this.c.setnx((Object)key, (Object)value));
    }

    @Override
    public String setex(String key, int seconds, String value) {
        return (String)this.c.await(this.c.setex((Object)key, (long)seconds, (Object)value));
    }

    @Override
    public Long decrBy(String key, long integer) {
        return (Long)this.c.await(this.c.decrby((Object)key, integer));
    }

    @Override
    public Long decr(String key) {
        return (Long)this.c.await(this.c.decr((Object)key));
    }

    @Override
    public Long incrBy(String key, long integer) {
        return (Long)this.c.await(this.c.incrby((Object)key, integer));
    }

    @Override
    public Long incr(String key) {
        return (Long)this.c.await(this.c.incr((Object)key));
    }

    @Override
    public Long append(String key, String value) {
        return (Long)this.c.await(this.c.append((Object)key, (Object)value));
    }

    @Override
    public String substr(String key, int start, int end) {
        return null;
    }

    @Override
    public Long hset(String key, String field, String value) {
        return (Long)this.c.await(this.c.hset((Object)key, (Object)field, (Object)value));
    }

    @Override
    public String hget(String key, String field) {
        return (String)this.c.await(this.c.hget((Object)key, (Object)field));
    }

    @Override
    public Long hsetnx(String key, String field, String value) {
        return (Long)this.c.await(this.c.hsetnx((Object)key, (Object)field, (Object)value));
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        return (String)this.c.await(this.c.hmset((Object)key, hash));
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        return (List)this.c.await(this.c.hmget((Object)key, (Object[])fields));
    }

    @Override
    public Long hincrBy(String key, String field, long value) {
        return (Long)this.c.await(this.c.hincrby((Object)key, (Object)field, value));
    }

    @Override
    public Boolean hexists(String key, String field) {
        return (Boolean)this.c.await(this.c.hexists((Object)key, (Object)field));
    }

    @Override
    public Long hdel(String key, String ... field) {
        return (Long)this.c.await(this.c.hdel((Object)key, (Object[])field));
    }

    @Override
    public Long hlen(String key) {
        return (Long)this.c.await(this.c.hlen((Object)key));
    }

    @Override
    public Set<String> hkeys(String key) {
        return (Set)this.c.await(this.c.hkeys((Object)key));
    }

    @Override
    public List<String> hvals(String key) {
        return (List)this.c.await(this.c.hvals((Object)key));
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return (Map)this.c.await(this.c.hgetall((Object)key));
    }

    @Override
    public Long rpush(String key, String ... values) {
        return (Long)this.c.await(this.c.rpush((Object)key, (Object[])values));
    }

    @Override
    public Long lpush(String key, String ... values) {
        return (Long)this.c.await(this.c.lpush((Object)key, (Object[])values));
    }

    @Override
    public Long llen(String key) {
        return (Long)this.c.await(this.c.llen((Object)key));
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        return (List)this.c.await(this.c.lrange((Object)key, start, end));
    }

    @Override
    public String ltrim(String key, long start, long end) {
        return (String)this.c.await(this.c.ltrim((Object)key, start, end));
    }

    @Override
    public String lindex(String key, long index) {
        return (String)this.c.await(this.c.lindex((Object)key, index));
    }

    @Override
    public String lset(String key, long index, String value) {
        return (String)this.c.await(this.c.lset((Object)key, index, (Object)value));
    }

    @Override
    public Long lrem(String key, long count, String value) {
        return (Long)this.c.await(this.c.lrem((Object)key, count, (Object)value));
    }

    @Override
    public String lpop(String key) {
        return (String)this.c.await(this.c.lpop((Object)key));
    }

    @Override
    public String rpop(String key) {
        return (String)this.c.await(this.c.rpop((Object)key));
    }

    @Override
    public Long sadd(String key, String ... member) {
        return (Long)this.c.await(this.c.sadd((Object)key, (Object[])member));
    }

    @Override
    public Set<String> smembers(String key) {
        return (Set)this.c.await(this.c.smembers((Object)key));
    }

    @Override
    public Long srem(String key, String ... member) {
        return (Long)this.c.await(this.c.srem((Object)key, (Object[])member));
    }

    @Override
    public String spop(String key) {
        return (String)this.c.await(this.c.spop((Object)key));
    }

    @Override
    public Long scard(String key) {
        return (Long)this.c.await(this.c.scard((Object)key));
    }

    @Override
    public Boolean sismember(String key, String member) {
        return (Boolean)this.c.await(this.c.sismember((Object)key, (Object)member));
    }

    @Override
    public String srandmember(String key) {
        return (String)this.c.await(this.c.srandmember((Object)key));
    }

    @Override
    public Long zadd(String key, double score, String member) {
        return (Long)this.c.await(this.c.zadd((Object)key, score, (Object)member));
    }

    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers) {
        Object[] scoresAndValues = new Object[scoreMembers.size() * 2];
        int i = 0;
        for (Map.Entry<String, Double> entry : scoreMembers.entrySet()) {
            scoresAndValues[i++] = entry.getValue();
            scoresAndValues[i++] = entry.getKey();
        }
        return (Long)this.c.await(this.c.zadd((Object)key, scoresAndValues));
    }

    @Override
    public List<String> zrange(String key, long start, long end) {
        return (List)this.c.await(this.c.zrange((Object)key, start, end));
    }

    @Override
    public Long zrem(String key, String ... member) {
        return (Long)this.c.await(this.c.zrem((Object)key, (Object[])member));
    }

    @Override
    public Double zincrby(String key, double score, String member) {
        return (Double)this.c.await(this.c.zincrby((Object)key, score, (Object)member));
    }

    @Override
    public Long zrank(String key, String member) {
        return (Long)this.c.await(this.c.zrank((Object)key, (Object)member));
    }

    @Override
    public Long zrevrank(String key, String member) {
        return (Long)this.c.await(this.c.zrevrank((Object)key, (Object)member));
    }

    @Override
    public List<String> zrevrange(String key, long start, long end) {
        return (List)this.c.await(this.c.zrevrange((Object)key, start, end));
    }

    @Override
    public Long zcard(String key) {
        return (Long)this.c.await(this.c.zcard((Object)key));
    }

    @Override
    public Double zscore(String key, String member) {
        return (Double)this.c.await(this.c.zscore((Object)key, (Object)member));
    }

    @Override
    public List<String> sort(String key) {
        return (List)this.c.await(this.c.sort((Object)key));
    }

    @Override
    public Long zcount(String key, double min, double max) {
        return (Long)this.c.await(this.c.zcount((Object)key, min, max));
    }

    @Override
    public Long zcount(String key, String min, String max) {
        return (Long)this.c.await(this.c.zcount((Object)key, min, max));
    }

    @Override
    public List<String> zrangeByScore(String key, double min, double max) {
        return (List)this.c.await(this.c.zrangebyscore((Object)key, min, max));
    }

    @Override
    public List<String> zrangeByScore(String key, String min, String max) {
        return (List)this.c.await(this.c.zrangebyscore((Object)key, min, max));
    }

    @Override
    public List<String> zrevrangeByScore(String key, double max, double min) {
        return (List)this.c.await(this.c.zrangebyscore((Object)key, min, max));
    }

    @Override
    public List<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        return (List)this.c.await(this.c.zrangebyscore((Object)key, min, max, (long)offset, (long)count));
    }

    @Override
    public List<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        return (List)this.c.await(this.c.zrangebyscore((Object)key, min, max, (long)offset, (long)count));
    }

    @Override
    public List<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        return (List)this.c.await(this.c.zrevrangebyscore((Object)key, max, min, (long)offset, (long)count));
    }

    @Override
    public List<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        return (List)this.c.await(this.c.zrevrangebyscore((Object)key, max, min, (long)offset, (long)count));
    }

    @Override
    public Long zremrangeByRank(String key, long start, long end) {
        return (Long)this.c.await(this.c.zremrangebyrank((Object)key, start, end));
    }

    @Override
    public Long zremrangeByScore(String key, double start, double end) {
        return (Long)this.c.await(this.c.zremrangebyscore((Object)key, start, end));
    }

    @Override
    public Long linsert(String key, boolean before, String pivot, String value) {
        return (Long)this.c.await(this.c.linsert((Object)key, before, (Object)pivot, (Object)value));
    }

    @Override
    public Long lpushx(String key, String string) {
        return (Long)this.c.await(this.c.lpush((Object)key, (Object[])new String[]{string}));
    }

    @Override
    public Long rpushx(String key, String string) {
        return (Long)this.c.await(this.c.rpushx((Object)key, (Object)string));
    }

    @Override
    public Object getResource() {
        return this.c;
    }

    @Override
    public void releaseResource() {
        this.bootstarp.shutdown();
    }

    @Override
    public boolean setObject(String key, Object o) {
        String value = JSON.toJSONString((Object)o);
        String s = this.set(key, value);
        return "OK".equalsIgnoreCase(s);
    }

    @Override
    public boolean setObject(String key, int seconds, Object o) {
        String setObjectRet = this.setex(key, seconds, JSON.toJSONString((Object)o));
        return "OK".equalsIgnoreCase(setObjectRet);
    }

    @Override
    public <T> T getObject(String key, Class<T> clazz) {
        String s = this.get(key);
        return (T)JSON.parseObject((String)s, clazz);
    }

    @Override
    public <T> List<T> getArray(String key, Class<T> clazz) {
        String s = this.get(key);
        return JSON.parseArray((String)s, clazz);
    }

    @Override
    public List<ScoreValue<String>> zrangeWithScores(String key, long start, long end) {
        return (List)this.c.await(this.c.zrangeWithScores((Object)key, start, end));
    }

    @Override
    public List<ScoreValue<String>> zrevrangeWithScores(String key, long start, long end) {
        return (List)this.c.await(this.c.zrevrangeWithScores((Object)key, start, end));
    }

    @Override
    public List<ScoreValue<String>> zrangeByScoreWithScores(String key, double min, double max) {
        return (List)this.c.await(this.c.zrangebyscoreWithScores((Object)key, min, max));
    }

    @Override
    public List<ScoreValue<String>> zrevrangeByScoreWithScores(String key, double max, double min) {
        return (List)this.c.await(this.c.zrevrangebyscoreWithScores((Object)key, max, min));
    }

    @Override
    public List<ScoreValue<String>> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        return (List)this.c.await(this.c.zrangebyscoreWithScores((Object)key, min, max, (long)offset, (long)count));
    }

    @Override
    public List<ScoreValue<String>> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        return (List)this.c.await(this.c.zrangebyscoreWithScores((Object)key, min, max, (long)offset, (long)count));
    }

    @Override
    public List<String> lrevrange(String key, long start, long end) {
        long s = end + 1L;
        long e = start + 1L;
        return this.lrange(key, -s, -e);
    }

    @Override
    public void close(Object resource) {
    }
}

