/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.redis;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jmind.base.lang.ScoreValue;
import jmind.base.util.DataUtil;
import jmind.base.util.MethodUtil;
import jmind.core.log.LogUtil;
import jmind.core.redis.Redis;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;

public abstract class AbstractJedis
implements Redis {
    public abstract JedisCommands getResource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(String method, Object ... args) {
        JedisCommands jedis = this.getResource();
        try {
            Object object = MethodUtil.invokeMethod((Object)jedis, (String)method, (Object[])args);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            Object var5_6 = null;
            return var5_6;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean exists(String key) {
        JedisCommands jedis = this.getResource();
        try {
            Boolean exists;
            Boolean bl = exists = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            LogUtil.error(e);
            Boolean bl = false;
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(String key, String val) {
        JedisCommands jedis = null;
        try {
            String string;
            jedis = this.getResource();
            String string2 = string = jedis.set(key, val);
            return string2;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        JedisCommands jedis = null;
        try {
            jedis = this.getResource();
            String string = jedis.get(key);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expire(String key, int seconds) {
        JedisCommands jedis = this.getResource();
        try {
            Long expire = jedis.expire(key, seconds);
            boolean bl = expire == 1L;
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long inc(String key) {
        JedisCommands jedis = this.getResource();
        try {
            Long val = jedis.incr(key);
            long l = val;
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            long l = 0L;
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lpush(String key, String ... str) {
        JedisCommands jedis = this.getResource();
        Long l = 0L;
        try {
            l = jedis.lpush(key, str);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.log.error("lpush err, len={}, first={} ,key=" + key, (Object)str.length, (Object)str[0]);
        }
        finally {
            this.close(jedis);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpush(String key, String ... str) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.rpush(key, str);
            return l;
        }
        catch (Exception e) {
            LogUtil.log.error("lpush err, key={},len={}, first={} ,{}", new Object[]{key, str.length, str[0], e});
        }
        finally {
            this.close(jedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> lrangePage(String key, int pageNo, int length) {
        JedisCommands jedis = this.getResource();
        try {
            List list;
            int k = pageNo * length;
            List list2 = list = jedis.lrange(key, (long)(k - length), (long)(k - 1));
            return list2;
        }
        catch (Exception e) {
            e.printStackTrace();
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long llen(String key) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.llen(key);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            Long l = 0L;
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(String key, double score, String member) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.zadd(key, score, member);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(jedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrem(String key, String ... member) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.zrem(key, member);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(jedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcard(String key) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.zcard(key);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            Long l = 0L;
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcount(String key, double min, double max) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.zcount(key, min, max);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            Long l = 0L;
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zscore(String key, String member) {
        JedisCommands jedis = this.getResource();
        try {
            Double d = jedis.zscore(key, member);
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            Double d = null;
            return d;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double zincby(String key, double score, String member) {
        JedisCommands jedis = this.getResource();
        try {
            double d = jedis.zincrby(key, score, member);
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            double d = 0.0;
            return d;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> zrange(String key, long start, long end) {
        JedisCommands jedis = this.getResource();
        try {
            Set set = jedis.zrange(key, start, end);
            ArrayList<String> arrayList = new ArrayList<String>(set);
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> zrevrange(String key, long start, long end) {
        JedisCommands jedis = this.getResource();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(jedis.zrevrange(key, start, end));
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> zrangeByScore(String key, double min, double max) {
        JedisCommands jedis = this.getResource();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(jedis.zrangeByScore(key, min, max));
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> zrevrangeByScore(String key, double max, double min) {
        JedisCommands jedis = this.getResource();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(jedis.zrevrangeByScore(key, max, min));
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByScore(String key, double min, double max) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.zremrangeByScore(key, min, max);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            Long l = 0L;
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zremrangeByRank(String key, int start, int end) {
        JedisCommands jedis = this.getResource();
        try {
            long l = jedis.zremrangeByRank(key, (long)start, (long)end);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            long l = 0L;
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String type(String key) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.type(key);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expireAt(String key, long unixTime) {
        JedisCommands jedis = this.getResource();
        try {
            boolean bl = jedis.expireAt(key, unixTime) == 1L;
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long ttl(String key) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.ttl(key);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setbit(String key, long offset, int value) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.setbit(key, offset, value == 1) != false ? 1L : 0L;
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getbit(String key, long offset) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.getbit(key, offset) != false ? 1L : 0L;
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setrange(String key, long offset, String value) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.setrange(key, offset, value);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.getrange(key, startOffset, endOffset);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSet(String key, String value) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.getSet(key, value);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setnx(String key, String value) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.setnx(key, value);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setex(String key, int seconds, String value) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.setex(key, seconds, value);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decrBy(String key, long integer) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.decrBy(key, integer);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decr(String key) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.decr(key);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrBy(String key, long integer) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.incrBy(key, integer);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(String key) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.incr(key);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long append(String key, String value) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.append(key, value);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String substr(String key, int start, int end) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.substr(key, start, end);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hset(String key, String field, String value) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.hset(key, field, value);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hget(String key, String field) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.hget(key, field);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hsetnx(String key, String field, String value) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.hsetnx(key, field, value);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hmset(String key, Map<String, String> hash) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.hmset(key, hash);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> hmget(String key, String ... fields) {
        JedisCommands jedis = this.getResource();
        try {
            List list = jedis.hmget(key, fields);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hincrBy(String key, String field, long value) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.hincrBy(key, field, value);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean hexists(String key, String field) {
        JedisCommands jedis = this.getResource();
        try {
            Boolean bl = jedis.hexists(key, field);
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hdel(String key, String ... field) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.hdel(key, field);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hlen(String key) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.hlen(key);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> hkeys(String key) {
        JedisCommands jedis = this.getResource();
        try {
            Set set = jedis.hkeys(key);
            return set;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> hvals(String key) {
        JedisCommands jedis = this.getResource();
        try {
            List list = jedis.hvals(key);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> hgetAll(String key) {
        JedisCommands jedis = this.getResource();
        try {
            Map map = jedis.hgetAll(key);
            return map;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> lrange(String key, long start, long end) {
        JedisCommands jedis = this.getResource();
        try {
            List list = jedis.lrange(key, start, end);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    @Override
    public List<String> lrevrange(String key, long start, long end) {
        long s = end + 1L;
        long e = start + 1L;
        return this.lrange(key, -s, -e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String ltrim(String key, long start, long end) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.ltrim(key, start, end);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lindex(String key, long index) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.lindex(key, index);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lset(String key, long index, String value) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.lset(key, index, value);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lrem(String key, long count, String value) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.lrem(key, count, value);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lpop(String key) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.lpop(key);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rpop(String key) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.rpop(key);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long sadd(String key, String ... member) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.sadd(key, member);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> smembers(String key) {
        JedisCommands jedis = this.getResource();
        try {
            Set set = jedis.smembers(key);
            return set;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long srem(String key, String ... member) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.srem(key, member);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String spop(String key) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.spop(key);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long scard(String key) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.scard(key);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean sismember(String key, String member) {
        JedisCommands jedis = this.getResource();
        try {
            Boolean bl = jedis.sismember(key, member);
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String srandmember(String key) {
        JedisCommands jedis = this.getResource();
        try {
            String string = jedis.srandmember(key);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.zadd(key, scoreMembers);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zincrby(String key, double score, String member) {
        JedisCommands jedis = this.getResource();
        try {
            Double d = jedis.zincrby(key, score, member);
            return d;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrank(String key, String member) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.zrank(key, member);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrevrank(String key, String member) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.zrevrank(key, member);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScoreValue<String>> zrangeWithScores(String key, long start, long end) {
        JedisCommands jedis = this.getResource();
        try {
            Set zrangeWithScores = jedis.zrangeWithScores(key, start, end);
            List<ScoreValue<String>> list = this.formart(zrangeWithScores);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScoreValue<String>> zrangeByScoreWithScores(String key, double min, double max) {
        JedisCommands jedis = this.getResource();
        try {
            Set zrangeWithScores = jedis.zrangeByScoreWithScores(key, min, max);
            List<ScoreValue<String>> list = this.formart(zrangeWithScores);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScoreValue<String>> zrevrangeByScoreWithScores(String key, double max, double min) {
        JedisCommands jedis = this.getResource();
        try {
            Set zrangeWithScores = jedis.zrevrangeByScoreWithScores(key, max, min);
            List<ScoreValue<String>> list = this.formart(zrangeWithScores);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScoreValue<String>> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        JedisCommands jedis = this.getResource();
        try {
            Set zrangeWithScores = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
            List<ScoreValue<String>> list = this.formart(zrangeWithScores);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScoreValue<String>> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        JedisCommands jedis = this.getResource();
        try {
            Set zrangeWithScores = jedis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            List<ScoreValue<String>> list = this.formart(zrangeWithScores);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    private List<ScoreValue<String>> formart(Set<Tuple> set) {
        ArrayList<ScoreValue<String>> list = new ArrayList<ScoreValue<String>>();
        for (Tuple tuple : set) {
            list.add((ScoreValue<String>)new ScoreValue(tuple.getScore(), (Object)tuple.getElement()));
        }
        Collections.sort(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScoreValue<String>> zrevrangeWithScores(String key, long start, long end) {
        JedisCommands jedis = this.getResource();
        try {
            Set set = jedis.zrevrangeWithScores(key, start, end);
            List<ScoreValue<String>> list = this.formart(set);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> sort(String key) {
        JedisCommands jedis = this.getResource();
        try {
            List list = jedis.sort(key);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> sort(String key, SortingParams sortingParameters) {
        JedisCommands jedis = this.getResource();
        try {
            List list = jedis.sort(key, sortingParameters);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcount(String key, String min, String max) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.zcount(key, min, max);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> zrangeByScore(String key, String min, String max) {
        JedisCommands jedis = this.getResource();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(jedis.zrangeByScore(key, min, max));
            return arrayList;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        JedisCommands jedis = this.getResource();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(jedis.zrangeByScore(key, min, max, offset, count));
            return arrayList;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> zrevrangeByScore(String key, String max, String min) {
        JedisCommands jedis = this.getResource();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(jedis.zrevrangeByScore(key, max, min));
            return arrayList;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        JedisCommands jedis = this.getResource();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(jedis.zrangeByScore(key, min, max, offset, count));
            return arrayList;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        JedisCommands jedis = this.getResource();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(jedis.zrevrangeByScore(key, max, min, offset, count));
            return arrayList;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        JedisCommands jedis = this.getResource();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(jedis.zrevrangeByScore(key, max, min, offset, count));
            return arrayList;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByRank(String key, long start, long end) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.zremrangeByRank(key, start, end);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zremrangeByScore(String key, String start, String end) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.zremrangeByScore(key, start, end);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long linsert(String key, boolean before, String pivot, String value) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.linsert(key, before ? BinaryClient.LIST_POSITION.BEFORE : BinaryClient.LIST_POSITION.AFTER, pivot, value);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lpushx(String key, String string) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.lpushx(key, new String[]{string});
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpushx(String key, String string) {
        JedisCommands jedis = this.getResource();
        try {
            Long l = jedis.rpushx(key, new String[]{string});
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    @Override
    public boolean setObject(String key, Object o) {
        String setObjectRet = this.set(key, JSON.toJSONString((Object)o));
        return "OK".equalsIgnoreCase(setObjectRet);
    }

    @Override
    public boolean setObject(String key, int seconds, Object o) {
        String setObjectRet = this.setex(key, seconds, JSON.toJSONString((Object)o));
        return "OK".equalsIgnoreCase(setObjectRet);
    }

    @Override
    public <T> T getObject(String key, Class<T> clazz) {
        String string = this.get(key);
        if (DataUtil.isEmpty((String)string)) {
            return null;
        }
        return (T)JSON.parseObject((String)string, clazz);
    }

    @Override
    public <T> List<T> getArray(String key, Class<T> clazz) {
        String s = this.get(key);
        return JSON.parseArray((String)s, clazz);
    }
}

