/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;
import jmind.core.rabbitmq.ExchangeType;
import jmind.core.rabbitmq.Producer;
import jmind.core.rabbitmq.RabbitmqFactory;

public class RabbitmqProducer
implements Producer {
    private final Channel channel;
    private final String exchangeName;

    public RabbitmqProducer(String name, IProperties p) throws IOException, TimeoutException {
        this(name, p, null, null, null, false);
    }

    public RabbitmqProducer(String name, IProperties p, String queueName, String exchangeName, ExchangeType type, boolean durable) throws IOException, TimeoutException {
        final Connection connection = RabbitmqFactory.getFactory().getConnection(name, p);
        this.channel = connection.createChannel();
        this.exchangeName = exchangeName;
        if (!DataUtil.isEmpty((String)queueName)) {
            this.channel.queueDeclare(queueName, durable, false, false, null);
        }
        if (!DataUtil.isEmpty((String)exchangeName)) {
            this.channel.exchangeDeclare(exchangeName, type.name(), durable);
        }
        if (connection != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        RabbitmqProducer.this.channel.close();
                        connection.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public boolean produce(String routingKey, String message) {
        return this.produce(this.exchangeName, routingKey, message);
    }

    @Override
    public boolean produce(String exchange, String routingKey, String message) {
        try {
            this.channel.basicPublish(exchange, routingKey, null, message.getBytes());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean produce(String exchange, String routingKey, int delayTime, String message) {
        AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties.Builder();
        AMQP.BasicProperties properties = builder.expiration(String.valueOf(delayTime)).deliveryMode(Integer.valueOf(2)).build();
        try {
            String DELAY_QUEUE = "DELAY_QUEUE_" + routingKey;
            this.channel.queueBind(routingKey, "amq.direct", routingKey);
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("x-dead-letter-exchange", "amq.direct");
            arguments.put("x-dead-letter-routing-key", routingKey);
            this.channel.queueDeclare(DELAY_QUEUE, true, false, false, arguments);
            this.channel.basicPublish("", DELAY_QUEUE, properties, message.getBytes());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean produce(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) {
        try {
            this.channel.basicPublish(exchange, routingKey, props, body);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

