/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.rabbitmq;

import com.rabbitmq.client.AMQP;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import jmind.base.lang.IProperties;
import jmind.base.lang.shard.ConsistentHashLoadBalance;
import jmind.base.lang.shard.LoadBalance;
import jmind.base.lang.shard.RoundRobinLoadBalance;
import jmind.core.rabbitmq.ExchangeType;
import jmind.core.rabbitmq.Producer;
import jmind.core.rabbitmq.RabbitmqProducer;

public class LoadBalanceProducer
implements Producer {
    private final LoadBalance<RabbitmqProducer> loadBalance;

    public LoadBalanceProducer(String names, IProperties p) throws IOException, TimeoutException {
        this(LoadBalance.Balance.RoundRobin, names, p, null, null, null, false);
    }

    public LoadBalanceProducer(String names, IProperties p, String queueName, String exchangeName, ExchangeType type, boolean durable) throws IOException, TimeoutException {
        this(LoadBalance.Balance.RoundRobin, names, p, queueName, exchangeName, type, durable);
    }

    public LoadBalanceProducer(LoadBalance.Balance balance, String names, IProperties p, String queueName, String exchangeName, ExchangeType type, boolean durable) throws IOException, TimeoutException {
        CopyOnWriteArrayList<RabbitmqProducer> producers = new CopyOnWriteArrayList<RabbitmqProducer>();
        for (String name : names.split(",")) {
            producers.add(new RabbitmqProducer(name, p, queueName, exchangeName, type, durable));
        }
        this.loadBalance = balance == LoadBalance.Balance.RoundRobin ? new RoundRobinLoadBalance(producers) : new ConsistentHashLoadBalance(producers);
    }

    @Override
    public boolean produce(String routingKey, String message) {
        return ((RabbitmqProducer)this.loadBalance.getShard(routingKey)).produce(routingKey, message);
    }

    @Override
    public boolean produce(String exchange, String routingKey, String message) {
        return ((RabbitmqProducer)this.loadBalance.getShard(routingKey)).produce(exchange, routingKey, message);
    }

    @Override
    public boolean produce(String exchange, String routingKey, int delayTime, String message) {
        return ((RabbitmqProducer)this.loadBalance.getShard(routingKey)).produce(exchange, routingKey, delayTime, message);
    }

    @Override
    public boolean produce(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) {
        return ((RabbitmqProducer)this.loadBalance.getShard(routingKey)).produce(exchange, routingKey, props, body);
    }
}

