/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.poi;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmind.base.util.RequestUtil;
import jmind.core.poi.Excel;
import org.apache.poi.ss.usermodel.Workbook;

public class PoiExportUtil {
    public static <T> void export(HttpServletRequest request, HttpServletResponse response, String fileName, Excel.Version version, String sheetName, List<T> list, String[] headers, String[] methods) {
        RequestUtil.setExcelHeader((String)(fileName + "." + version.name()), (HttpServletRequest)request, (HttpServletResponse)response);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            Workbook workbook = null;
            workbook = methods == null ? Excel.getExcel(version).exportExcel(sheetName, list, headers) : Excel.getExcel(version).exportExcel(sheetName, list, headers, methods);
            if (workbook != null) {
                workbook.write((OutputStream)out);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public static void export(HttpServletRequest request, HttpServletResponse response, String fileName, Excel.Version version, String sheetName, List<?> list) {
        RequestUtil.setExcelHeader((String)(fileName + "." + version.name()), (HttpServletRequest)request, (HttpServletResponse)response);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            Workbook workbook = Excel.getExcel(version).exportExcel(sheetName, list);
            if (workbook != null) {
                workbook.write((OutputStream)out);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

