/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.poi;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import jmind.base.util.FileUtil;
import jmind.core.poi.XlsExcel;
import jmind.core.poi.XlsxExcel;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class Excel {
    public static Excel getExcel(Version version) {
        return version == Version.xls ? XlsExcel.INSTANCE : XlsxExcel.INSTANCE;
    }

    public static Excel getExcel(String fileName) {
        String type = FileUtil.getExtensionName((String)fileName);
        return Excel.getExcel(Version.valueOf(type.toLowerCase()));
    }

    public abstract Workbook exportExcel(String var1, List<?> var2);

    public abstract <T> Workbook exportExcel(String var1, List<T> var2, String[] var3);

    public abstract <T> Workbook exportExcel(String var1, List<T> var2, String[] var3, String[] var4);

    public abstract Workbook exportMapExcel(String var1, List<Map<String, String>> var2);

    public abstract List<String> excel2StrList(InputStream var1);

    public <T> List<T> excel2List(InputStream in, Class<T> claz) {
        Field[] fields2 = claz.getDeclaredFields();
        String[] fields = new String[fields2.length];
        for (int i = 0; i < fields2.length; ++i) {
            fields[i] = fields2[2].getName();
        }
        return this.excel2List(in, claz, fields, 0);
    }

    public abstract <T> List<T> excel2List(InputStream var1, Class<T> var2, String[] var3, int var4);

    public List<Map<String, String>> excel2Map(String excelFile, String[] strKey) throws FileNotFoundException {
        FileInputStream in = new FileInputStream(excelFile);
        return this.excel2Map(in, strKey);
    }

    public abstract List<Map<String, String>> excel2Map(InputStream var1, String[] var2);

    public static enum Version {
        xls,
        xlsx;

    }
}

