/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.mongodb;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmind.base.util.DataUtil;
import jmind.base.util.DateUtil;
import org.bson.types.ObjectId;
import org.springframework.util.CollectionUtils;

public class MongodbTool {
    public static List<DBObject> sort(List<DBObject> res, final String val) {
        Collections.sort(res, new Comparator<DBObject>(){

            @Override
            public int compare(DBObject p1, DBObject p2) {
                Integer count1 = (Integer)p1.get(val);
                Integer count2 = (Integer)p2.get(val);
                return count2.compareTo(count1);
            }
        });
        return res;
    }

    public static List<ObjectId> toObjectIdList(List<String> fids) {
        return Lists.transform(fids, (Function)new Function<String, ObjectId>(){

            public ObjectId apply(String input) {
                return new ObjectId(input);
            }
        });
    }

    public static List<ObjectId> toObjectIdList(String[] fids) {
        ArrayList<ObjectId> fid = new ArrayList<ObjectId>();
        for (String id : fids) {
            fid.add(new ObjectId(id));
        }
        return fid;
    }

    public static final <T> List<T> toIdList(List<DBObject> list, String key) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (DBObject obj : list) {
            newList.add(obj.get(key));
        }
        return newList;
    }

    public static final DBObject getOneDay(String date) {
        Date start = DateUtil.parse((String)date, (String[])new String[]{"yyyyMMdd"});
        Date end = DateUtil.add((Date)start, (int)5, (int)1);
        BasicDBObject query = new BasicDBObject("$gte", (Object)new ObjectId(start)).append("$lt", (Object)new ObjectId(end));
        return BasicDBObjectBuilder.start((String)"_id", (Object)query).get();
    }

    public static final DBObject getDays(String startDate, String endDate) {
        Date start = DateUtil.parse((String)startDate, (String[])new String[]{"yyyyMMdd"});
        Date end = DateUtil.parse((String)endDate, (String[])new String[]{"yyyyMMdd"});
        BasicDBObject query = new BasicDBObject("$gte", (Object)new ObjectId(start)).append("$lt", (Object)new ObjectId(end));
        return BasicDBObjectBuilder.start((String)"_id", (Object)query).get();
    }

    public static final ObjectId getOidByDate(String date) {
        Date start = DateUtil.parse((String)date, (String[])new String[]{"yyyyMMdd"});
        return new ObjectId(start);
    }

    public static final String parseOid(ObjectId oid, String formart) {
        if (DataUtil.isEmpty((String)formart)) {
            return DateUtil.format((long)oid.getTime());
        }
        return DateUtil.format((Date)new Date(oid.getTime()), (String)formart);
    }

    public static BasicDBObject add(BasicDBObject source, BasicDBObject obj) {
        for (String field : obj.keySet()) {
            Object val = obj.get(field);
            if (val instanceof BasicDBObject) {
                if (!source.containsField(field)) {
                    source.put((Object)field, (Object)new BasicDBObject());
                }
                MongodbTool.add((BasicDBObject)source.get(field), (BasicDBObject)val);
                continue;
            }
            if (!(val instanceof Number)) continue;
            int c = ((Number)val).intValue();
            if (source.containsField(field)) {
                source.put((Object)field, (Object)(source.getInt(field) + c));
                continue;
            }
            source.put((Object)field, (Object)c);
        }
        return source;
    }

    public Map<Object, DBObject> toMap(List<DBObject> list, String key) {
        HashMap<Object, DBObject> map = new HashMap<Object, DBObject>();
        for (DBObject jo : list) {
            Object k = jo.removeField(key);
            map.put(k, jo);
        }
        return map;
    }
}

