/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MapReduceOutput;
import com.mongodb.WriteResult;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jmind.base.util.DateUtil;

public class MongoCollection {
    public static final String ID = "_id";
    public static final int ONE = 1;
    private DBCollection coll;
    public String name = this.getClass().getSimpleName();

    public MongoCollection(DB db) {
        this.coll = db.getCollection(this.name);
    }

    public MongoCollection(DB db, String suffix) {
        this.coll = db.getCollection(this.name + "_" + suffix);
    }

    public String getToday() {
        return DateUtil.Today;
    }

    public Collection<String> keys() {
        return this.getColl().findOne().keySet();
    }

    public DBCollection getColl() {
        return this.coll;
    }

    protected BasicDBObjectBuilder builder() {
        return BasicDBObjectBuilder.start();
    }

    protected BasicDBObjectBuilder builder(String key, Object val) {
        return BasicDBObjectBuilder.start((String)key, (Object)val);
    }

    public void save(DBObject o) {
        this.getColl().save(o);
    }

    public void insert(DBObject ... arr) {
        this.getColl().insert(arr);
    }

    public void insert(List<DBObject> arr) {
        this.getColl().insert(arr);
    }

    public WriteResult update(DBObject q, DBObject o) {
        return this.getColl().update(q, this.builder("$set", o).get());
    }

    public void updateById(DBObject update) {
        Object id = update.removeField(ID);
        if (id != null) {
            this.getColl().update(this.builder(ID, id).get(), this.builder("$set", update).get());
        }
    }

    public WriteResult set(Object _id, DBObject o) {
        return this.getColl().update(this.builder(ID, _id).get(), this.builder("$set", o).get(), true, false);
    }

    public void inc(Object primaryKey, String field, int num) {
        BasicDBObject update = new BasicDBObject(field, (Object)num);
        this.getColl().update((DBObject)new BasicDBObject(ID, primaryKey), (DBObject)new BasicDBObject("$inc", (Object)update), true, false);
    }

    public void remove(Object primaryKey) {
        this.getColl().remove(this.builder(ID, primaryKey).get());
    }

    public List<DBObject> betweenAnd(Object start, Object end) {
        DBObject query = this.builder(ID, this.builder("$gte", start).add("$lte", end).get()).get();
        return this.getColl().find(query).toArray();
    }

    public List<DBObject> find(DBObject query) {
        return this.getColl().find(query).toArray();
    }

    public List<DBObject> find(DBObject query, int start, int limit) {
        return this.getColl().find(query).skip(start).limit(limit).toArray();
    }

    public DBObject findOne(Object primaryKey) {
        return this.getColl().findOne(primaryKey);
    }

    public DBObject findOne(DBObject o) {
        return this.getColl().findOne(o);
    }

    public DBObject findOne(Object obj, DBObject fields) {
        return this.getColl().findOne(obj, fields);
    }

    public int getMax(String field) {
        Integer num = 0;
        DBCursor cursor = this.getColl().find(null, this.builder(field, 1).get()).sort(this.builder(field, -1).get()).limit(1);
        if (cursor.hasNext()) {
            DBObject next = cursor.next();
            num = (Integer)next.get(field);
        }
        return num;
    }

    public int getMin(String field) {
        Integer num = 0;
        DBCursor cursor = this.getColl().find(null, this.builder(field, 1).get()).sort(this.builder(field, 1).get()).limit(1);
        if (cursor.hasNext()) {
            DBObject next = cursor.next();
            num = (Integer)next.get(field);
        }
        return num;
    }

    public int sum(String field, DBObject query) {
        String map = "function(){ var f=this." + field + "; if(f){emit(1, f);} }";
        String reduce = " function(k,vals) {var count=0 ;for(var i in vals){count+=vals[i];\t}return count}";
        String collName = "tmp_" + field;
        MapReduceOutput result = this.getColl().mapReduce(map, reduce, collName, query);
        Iterator iterator = result.results().iterator();
        if (iterator.hasNext()) {
            Object value = ((DBObject)result.results().iterator().next()).get("value");
            result.drop();
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Double) {
                return ((Double)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }
        result.drop();
        return 0;
    }

    public long count() {
        return this.getColl().count();
    }

    public List<DBObject> getTopByField(String field, int max) {
        DBCursor cursor = this.getColl().find(null, (DBObject)new BasicDBObject(field, (Object)1)).sort((DBObject)new BasicDBObject(field, (Object)-1)).limit(max);
        return cursor.toArray();
    }

    public List<DBObject> getTopByField(DBCollection coll, String field, int max) {
        DBCursor cursor = coll.find(null, (DBObject)new BasicDBObject(field, (Object)1)).sort((DBObject)new BasicDBObject(field, (Object)-1)).limit(max);
        return cursor.toArray();
    }
}

