/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.manager;

import java.util.concurrent.FutureTask;
import javax.sql.DataSource;
import jmind.core.jdbc.DataSourceFactory;
import jmind.core.manager.AbstractManager;
import org.apache.commons.dbcp.BasicDataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcManager
extends AbstractManager<JdbcTemplate> {
    private static volatile JdbcManager manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JdbcManager getInstance() {
        if (manager != null) return manager;
        Class<JdbcManager> clazz = JdbcManager.class;
        synchronized (JdbcManager.class) {
            if (manager != null) return manager;
            manager = new JdbcManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    @Override
    public JdbcTemplate create(String name) {
        DataSource ds = DataSourceFactory.createFactory(this.getProperties().getProperty("jdbc." + name + ".datasource")).getSource(name, this.getProperties());
        return new JdbcTemplate(ds);
    }

    @Override
    public void releaseResource() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (FutureTask source : JdbcManager.this.RESOURCES.values()) {
                    try {
                        BasicDataSource ds = (BasicDataSource)((JdbcTemplate)source.get()).getDataSource();
                        ds.close();
                    }
                    catch (Exception e) {
                        JdbcManager.this.logger.error("", (Throwable)e);
                    }
                }
                JdbcManager.this.logger.debug("releaseResource {}", (Object)this.getClass().getName());
            }
        });
    }
}

