/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.jdbc;

import java.sql.SQLException;
import javax.sql.DataSource;
import jmind.base.lang.IProperties;
import jmind.base.util.DataUtil;
import jmind.core.jdbc.DataSourceFactory;

public class DruidDataSource
extends DataSourceFactory {
    @Override
    public DataSource getSource(String name, IProperties p) {
        com.alibaba.druid.pool.DruidDataSource ds = new com.alibaba.druid.pool.DruidDataSource();
        String url = p.getProperty("jdbc." + name + ".url");
        System.out.println("jdbc." + name + ".url=" + url);
        if (DataUtil.isEmpty((String)url)) {
            return null;
        }
        ds.setUrl(url);
        String driverClassName = "com.mysql.cj.jdbc.Driver";
        if (url.startsWith("jdbc:oracle")) {
            driverClassName = "oracle.jdbc.driver.OracleDriver";
            ds.setValidationQuery("SELECT * FROM DUAL");
        } else if (url.startsWith("jdbc:sqlserver")) {
            driverClassName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        } else {
            ds.setValidationQuery("SELECT 1");
        }
        ds.setDriverClassName(driverClassName);
        ds.setUsername(p.getProperty("jdbc." + name + ".username"));
        ds.setPassword(p.getProperty("jdbc." + name + ".password"));
        ds.setInitialSize(3);
        ds.setMinIdle(3);
        int maxActive = DataUtil.toInt((String)p.getProperty("jdbc." + name + ".maxActive", "20"));
        ds.setMaxActive(maxActive);
        ds.setDefaultReadOnly(Boolean.valueOf(Boolean.parseBoolean(p.getProperty("jdbc." + name + ".slave"))));
        ds.setRemoveAbandoned(true);
        ds.setRemoveAbandonedTimeout(300);
        ds.setLogAbandoned(true);
        ds.setTestOnBorrow(false);
        ds.setTestOnReturn(false);
        ds.setTestWhileIdle(true);
        ds.setTimeBetweenEvictionRunsMillis(3000L);
        ds.setMinEvictableIdleTimeMillis(300000L);
        try {
            ds.setFilters("mergeStat,wall");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ds.setMaxWait(60000L);
        ds.setPoolPreparedStatements(true);
        ds.setMaxPoolPreparedStatementPerConnectionSize(20);
        return ds;
    }
}

