/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class DatabaseConfig {
    private final Map<String, String> map = new ConcurrentHashMap<String, String>();
    private String[] database;

    public DatabaseConfig(String name) {
        try {
            Document doc = Jsoup.parse((InputStream)this.getClass().getClassLoader().getResourceAsStream(name), (String)"UTF-8", (String)"");
            this.database = doc.getElementsByTag("database").first().attr("name").split("#");
            Elements tables = doc.select("sqls");
            for (Element table : tables) {
                String tableName = table.attr("name");
                Elements sqls = table.select("sql");
                for (Element sql : sqls) {
                    this.map.put(tableName + "#" + sql.attr("name"), sql.text().trim());
                }
            }
        }
        catch (IOException e) {
            System.err.println("err file=" + name);
            e.printStackTrace();
        }
    }

    public String getDatabase(int index) {
        return this.database[index];
    }

    public String getSql(String key) {
        return this.map.get(key);
    }

    public String getSql(String prefix, String suffix) {
        return this.map.get(prefix + "#" + suffix);
    }
}

