/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.jdbc;

import java.util.List;
import java.util.Map;
import jmind.core.jdbc.BeanJdbc;
import jmind.core.jdbc.DatabaseConfig;
import jmind.core.manager.JdbcManager;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public abstract class Database<E>
extends BeanJdbc<E> {
    protected final String className = this.getClass().getSimpleName();

    public abstract DatabaseConfig getConfig();

    @Override
    public JdbcTemplate getJdbc(int source) {
        String name = this.getConfig().getDatabase(source);
        return (JdbcTemplate)JdbcManager.getInstance().getResource(name);
    }

    public String getSql(String key) {
        return this.getConfig().getSql(this.className, key);
    }

    public String getComplexSql(String key) {
        String[] data = key.split("#");
        String sql = this.getConfig().getSql(this.className, data[0]);
        if (data.length > 1) {
            sql = String.format(sql, data[1]);
        }
        return sql;
    }

    @Override
    public Number insertAndReturnKey(String key, String keyName, Object ... args) {
        return super.insertAndReturnKey(this.getSql(key), keyName, args);
    }

    @Override
    public int update(String key, Object ... args) {
        return super.update(this.getSql(key), args);
    }

    @Override
    public E findOne(int source, String key, Object ... args) {
        return super.findOne(source, this.getSql(key), args);
    }

    @Override
    public <T> T findColumValue(int source, String key, Class<T> requiredType, Object ... args) {
        return super.findColumValue(source, this.getSql(key), requiredType, args);
    }

    @Override
    public <T> List<T> findColumValues(int source, String key, Class<T> requiredType, Object ... args) {
        return super.findColumValues(source, this.getSql(key), requiredType, args);
    }

    @Override
    public List<E> find(int source, String sql, Object ... args) {
        return super.find(source, this.getSql(sql), args);
    }

    @Override
    public int findForInt(int source, String key, Object ... args) {
        return super.findForInt(source, this.getSql(key), args);
    }

    @Override
    public Map<String, Object> findForMap(int source, String key, Object ... args) {
        return super.findForMap(source, this.getSql(key), args);
    }

    @Override
    public List<Map<String, Object>> findForList(int source, String key, Object ... args) {
        return super.findForList(source, this.getSql(key), args);
    }

    @Override
    public List<E> sFind(int source, String key, SqlParameterSource args) {
        return super.sFind(source, this.getSql(key), args);
    }
}

