/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.ip;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import jmind.base.lang.IProperties;
import jmind.core.ip.IPEntry;
import jmind.core.ip.Utils;
import jmind.core.support.HttpUtil;

public class IPSeeker {
    private static final int IP_RECORD_LENGTH = 7;
    private static final byte AREA_FOLLOWED = 1;
    private static final byte NO_AREA = 2;
    private RandomAccessFile ipFile;
    private MappedByteBuffer mbb;
    private long ipBegin;
    private long ipEnd;
    private IPLocation loc = new IPLocation();
    private byte[] buf = new byte[100];
    private byte[] b4 = new byte[4];
    private byte[] b3 = new byte[3];

    public IPSeeker(IProperties p) {
        try {
            if (p == null) {
                File f = new File(this.getClass().getClassLoader().getResource("QQWry.Dat").toURI());
                this.ipFile = new RandomAccessFile(f, "r");
            } else {
                this.ipFile = new RandomAccessFile(p.getProperty("QQWry"), "r");
            }
        }
        catch (Exception e) {
            System.err.println("IP\u5730\u5740\u4fe1\u606f\u6587\u4ef6\u6ca1\u6709\u627e\u5230\uff0cIP\u663e\u793a\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528");
            this.ipFile = null;
            e.printStackTrace();
        }
        if (this.ipFile != null) {
            try {
                this.ipBegin = this.readLong4(0L);
                this.ipEnd = this.readLong4(4L);
                if (this.ipBegin == -1L || this.ipEnd == -1L) {
                    this.ipFile.close();
                    this.ipFile = null;
                }
            }
            catch (IOException e) {
                System.out.println("IP\u5730\u5740\u4fe1\u606f\u6587\u4ef6\u683c\u5f0f\u6709\u9519\u8bef\uff0cIP\u663e\u793a\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528");
                this.ipFile = null;
            }
        }
    }

    public List<IPEntry> getIPEntriesDebug(String s) {
        ArrayList<IPEntry> ret = new ArrayList<IPEntry>();
        long endOffset = this.ipEnd + 4L;
        for (long offset = this.ipBegin + 4L; offset <= endOffset; offset += 7L) {
            long temp = this.readLong3(offset);
            if (temp == -1L) continue;
            IPLocation loc = this.getIPLocation(temp);
            if (loc.country.indexOf(s) == -1 && loc.area.indexOf(s) == -1) continue;
            IPEntry entry = new IPEntry();
            entry.country = loc.country;
            entry.area = loc.area;
            this.readIP(offset - 4L, this.b4);
            entry.beginIp = Utils.getIpStringFromBytes(this.b4);
            this.readIP(temp, this.b4);
            entry.endIp = Utils.getIpStringFromBytes(this.b4);
            ret.add(entry);
        }
        return ret;
    }

    public List<IPEntry> getIPEntries(String s) {
        ArrayList<IPEntry> ret = new ArrayList<IPEntry>();
        try {
            if (this.mbb == null) {
                FileChannel fc = this.ipFile.getChannel();
                this.mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.ipFile.length());
                this.mbb.order(ByteOrder.LITTLE_ENDIAN);
            }
            int endOffset = (int)this.ipEnd;
            for (int offset = (int)this.ipBegin + 4; offset <= endOffset; offset += 7) {
                int temp = this.readInt3(offset);
                if (temp == -1) continue;
                IPLocation loc = this.getIPLocation(temp);
                if (loc.country.indexOf(s) == -1 && loc.area.indexOf(s) == -1) continue;
                IPEntry entry = new IPEntry();
                entry.country = loc.country;
                entry.area = loc.area;
                this.readIP(offset - 4, this.b4);
                entry.beginIp = Utils.getIpStringFromBytes(this.b4);
                this.readIP(temp, this.b4);
                entry.endIp = Utils.getIpStringFromBytes(this.b4);
                ret.add(entry);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private int readInt3(int offset) {
        this.mbb.position(offset);
        return this.mbb.getInt() & 0xFFFFFF;
    }

    private int readInt3() {
        return this.mbb.getInt() & 0xFFFFFF;
    }

    public String getCountry(byte[] ip) {
        if (this.ipFile == null) {
            return "\u9519\u8bef\u7684IP\u6570\u636e\u5e93\u6587\u4ef6";
        }
        IPLocation loc = this.getIPLocation(ip);
        return loc.country;
    }

    public String getCountry(String ip) {
        return this.getCountry(Utils.getIpByteArrayFromString(ip));
    }

    public String getArea(byte[] ip) {
        if (this.ipFile == null) {
            return "\u9519\u8bef\u7684IP\u6570\u636e\u5e93\u6587\u4ef6";
        }
        IPLocation loc = this.getIPLocation(ip);
        return loc.area;
    }

    public String getArea(String ip) {
        return this.getArea(Utils.getIpByteArrayFromString(ip));
    }

    private IPLocation getIPLocation(byte[] ip) {
        IPLocation info = null;
        long offset = this.locateIP(ip);
        if (offset != -1L) {
            info = this.getIPLocation(offset);
        }
        if (info == null) {
            info = new IPLocation();
        }
        return info;
    }

    private long readLong4(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            ret |= (long)(this.ipFile.readByte() & 0xFF);
            ret |= (long)(this.ipFile.readByte() << 8 & 0xFF00);
            ret |= (long)(this.ipFile.readByte() << 16 & 0xFF0000);
            return ret |= (long)(this.ipFile.readByte() << 24 & 0xFF000000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3() {
        long ret = 0L;
        try {
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private void readIP(long offset, byte[] ip) {
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(ip);
            byte temp = ip[0];
            ip[0] = ip[3];
            ip[3] = temp;
            temp = ip[1];
            ip[1] = ip[2];
            ip[2] = temp;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readIP(int offset, byte[] ip) {
        this.mbb.position(offset);
        this.mbb.get(ip);
        byte temp = ip[0];
        ip[0] = ip[3];
        ip[3] = temp;
        temp = ip[1];
        ip[1] = ip[2];
        ip[2] = temp;
    }

    private int compareIP(byte[] ip, byte[] beginIp) {
        for (int i = 0; i < 4; ++i) {
            int r = this.compareByte(ip[i], beginIp[i]);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    private int compareByte(byte b1, byte b2) {
        if ((b1 & 0xFF) > (b2 & 0xFF)) {
            return 1;
        }
        if ((b1 ^ b2) == 0) {
            return 0;
        }
        return -1;
    }

    private long locateIP(byte[] ip) {
        long m = 0L;
        this.readIP(this.ipBegin, this.b4);
        int r = this.compareIP(ip, this.b4);
        if (r == 0) {
            return this.ipBegin;
        }
        if (r < 0) {
            return -1L;
        }
        long i = this.ipBegin;
        long j = this.ipEnd;
        while (i < j) {
            m = this.getMiddleOffset(i, j);
            this.readIP(m, this.b4);
            r = this.compareIP(ip, this.b4);
            if (r > 0) {
                i = m;
                continue;
            }
            if (r < 0) {
                if (m == j) {
                    m = j -= 7L;
                    continue;
                }
                j = m;
                continue;
            }
            return this.readLong3(m + 4L);
        }
        m = this.readLong3(m + 4L);
        this.readIP(m, this.b4);
        r = this.compareIP(ip, this.b4);
        if (r <= 0) {
            return m;
        }
        return -1L;
    }

    private long getMiddleOffset(long begin, long end) {
        long records = (end - begin) / 7L;
        if ((records >>= 1) == 0L) {
            records = 1L;
        }
        return begin + records * 7L;
    }

    private IPLocation getIPLocation(long offset) {
        try {
            this.ipFile.seek(offset + 4L);
            byte b = this.ipFile.readByte();
            if (b == 1) {
                long countryOffset = this.readLong3();
                this.ipFile.seek(countryOffset);
                b = this.ipFile.readByte();
                if (b == 2) {
                    this.loc.country = this.readString(this.readLong3());
                    this.ipFile.seek(countryOffset + 4L);
                } else {
                    this.loc.country = this.readString(countryOffset);
                }
                this.loc.area = this.readArea(this.ipFile.getFilePointer());
            } else if (b == 2) {
                this.loc.country = this.readString(this.readLong3());
                this.loc.area = this.readArea(offset + 8L);
            } else {
                this.loc.country = this.readString(this.ipFile.getFilePointer() - 1L);
                this.loc.area = this.readArea(this.ipFile.getFilePointer());
            }
            return this.loc;
        }
        catch (IOException e) {
            return null;
        }
    }

    private IPLocation getIPLocation(int offset) {
        this.mbb.position(offset + 4);
        byte b = this.mbb.get();
        if (b == 1) {
            int countryOffset = this.readInt3();
            this.mbb.position(countryOffset);
            b = this.mbb.get();
            if (b == 2) {
                this.loc.country = this.readString(this.readInt3());
                this.mbb.position(countryOffset + 4);
            } else {
                this.loc.country = this.readString(countryOffset);
            }
            this.loc.area = this.readArea(this.mbb.position());
        } else if (b == 2) {
            this.loc.country = this.readString(this.readInt3());
            this.loc.area = this.readArea(offset + 8);
        } else {
            this.loc.country = this.readString(this.mbb.position() - 1);
            this.loc.area = this.readArea(this.mbb.position());
        }
        return this.loc;
    }

    private String readArea(long offset) throws IOException {
        this.ipFile.seek(offset);
        byte b = this.ipFile.readByte();
        if (b == 1 || b == 2) {
            long areaOffset = this.readLong3(offset + 1L);
            if (areaOffset == 0L) {
                return "\u672a\u77e5\u5730\u533a";
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readArea(int offset) {
        this.mbb.position(offset);
        byte b = this.mbb.get();
        if (b == 1 || b == 2) {
            int areaOffset = this.readInt3();
            if (areaOffset == 0) {
                return "\u672a\u77e5\u5730\u533a";
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readString(long offset) {
        try {
            this.ipFile.seek(offset);
            int i = 0;
            this.buf[i] = this.ipFile.readByte();
            while (this.buf[i] != 0) {
                this.buf[++i] = this.ipFile.readByte();
            }
            if (i != 0) {
                return Utils.getString(this.buf, 0, i, "GBK");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    private String readString(int offset) {
        try {
            this.mbb.position(offset);
            int i = 0;
            this.buf[i] = this.mbb.get();
            while (this.buf[i] != 0) {
                this.buf[++i] = this.mbb.get();
            }
            if (i != 0) {
                return Utils.getString(this.buf, 0, i, "GBK");
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getAddress(String ip) {
        return this.getCountry(ip) + " " + this.getArea(ip);
    }

    public static String getFormApi(String ip) {
        return HttpUtil.get("http://api.t.sina.com.cn/location/geocode/ip_to_geo.json?source=4163963661&ip=" + ip);
    }

    public static void main(String[] args) {
        String ip = "211.157.166.18";
        IPSeeker ipSeeker = new IPSeeker(null);
        System.out.println(ipSeeker.getCountry(ip));
        System.out.println(ipSeeker.getArea(ip));
        System.out.println(IPSeeker.getFormApi(ip));
    }

    private class IPLocation {
        public String country = "";
        public String area = "";
    }
}

