/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.ip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class IPParser {
    private String DbPath = "src/main/resources/QQWry.Dat";
    private String Country;
    private String LocalStr;
    private long IPN;
    private int RecordCount;
    private int CountryFlag;
    private long RangE;
    private long RangB;
    private long OffSet;
    private long StartIP;
    private long EndIP;
    private long FirstStartIP;
    private long LastStartIP;
    private long EndIPOff;
    private RandomAccessFile fis;
    private byte[] buff;

    private long B2L(byte[] b) {
        long ret = 0L;
        for (int i = 0; i < b.length; ++i) {
            long t = 1L;
            for (int j = 0; j < i; ++j) {
                t *= 256L;
            }
            ret += (long)(b[i] < 0 ? 256 + b[i] : b[i]) * t;
        }
        return ret;
    }

    private long ipToInt(String ip) {
        String[] arr = ip.split("\\.");
        long ret = 0L;
        for (int i = 0; i < arr.length; ++i) {
            long l = 1L;
            for (int j = 0; j < i; ++j) {
                l *= 256L;
            }
            try {
                ret += Long.parseLong(arr[arr.length - i - 1]) * l;
                continue;
            }
            catch (Exception e) {
                ret += 0L;
            }
        }
        return ret;
    }

    public void seek(String ip) throws Exception {
        this.IPN = this.ipToInt(ip);
        this.fis = new RandomAccessFile(this.DbPath, "r");
        this.buff = new byte[4];
        this.fis.seek(0L);
        this.fis.read(this.buff);
        this.FirstStartIP = this.B2L(this.buff);
        this.fis.read(this.buff);
        this.LastStartIP = this.B2L(this.buff);
        this.RecordCount = (int)((this.LastStartIP - this.FirstStartIP) / 7L);
        if (this.RecordCount <= 1) {
            this.Country = "\u672a\u77e5";
            this.LocalStr = "\u672a\u77e5";
            throw new Exception();
        }
        this.RangB = 0L;
        this.RangE = this.RecordCount;
        do {
            long RecNo = (this.RangB + this.RangE) / 2L;
            this.getStartIP(RecNo);
            if (this.IPN == this.StartIP) {
                this.RangB = RecNo;
                break;
            }
            if (this.IPN > this.StartIP) {
                this.RangB = RecNo;
                continue;
            }
            this.RangE = RecNo;
        } while (this.RangB < this.RangE - 1L);
        this.getStartIP(this.RangB);
        this.getEndIP();
        this.getCountry(this.IPN);
        this.fis.close();
    }

    private String getFlagStr(long OffSet) throws IOException {
        int flag = 0;
        while (true) {
            this.fis.seek(OffSet);
            this.buff = new byte[1];
            this.fis.read(this.buff);
            int n = flag = this.buff[0] < 0 ? 256 + this.buff[0] : this.buff[0];
            if (flag != 1 && flag != 2) break;
            this.buff = new byte[3];
            this.fis.read(this.buff);
            if (flag == 2) {
                this.CountryFlag = 2;
                this.EndIPOff = OffSet - 4L;
            }
            OffSet = this.B2L(this.buff);
        }
        if (OffSet < 12L) {
            return "";
        }
        this.fis.seek(OffSet);
        return this.getStr();
    }

    private String getStr() throws IOException {
        long l = this.fis.length();
        ByteArrayOutputStream byteout = new ByteArrayOutputStream();
        byte c = this.fis.readByte();
        do {
            byteout.write(c);
        } while ((c = this.fis.readByte()) != 0 && this.fis.getFilePointer() < l);
        return byteout.toString();
    }

    private void getCountry(long ip) throws IOException {
        if (this.CountryFlag == 1 || this.CountryFlag == 2) {
            this.Country = this.getFlagStr(this.EndIPOff + 4L);
            if (this.CountryFlag == 1) {
                this.LocalStr = this.getFlagStr(this.fis.getFilePointer());
                if (this.IPN >= this.ipToInt("255.255.255.0") && this.IPN <= this.ipToInt("255.255.255.255")) {
                    this.LocalStr = this.getFlagStr(this.EndIPOff + 21L);
                    this.Country = this.getFlagStr(this.EndIPOff + 12L);
                }
            } else {
                this.LocalStr = this.getFlagStr(this.EndIPOff + 8L);
            }
        } else {
            this.Country = this.getFlagStr(this.EndIPOff + 4L);
            this.LocalStr = this.getFlagStr(this.fis.getFilePointer());
        }
    }

    private long getEndIP() throws IOException {
        this.fis.seek(this.EndIPOff);
        this.buff = new byte[4];
        this.fis.read(this.buff);
        this.EndIP = this.B2L(this.buff);
        this.buff = new byte[1];
        this.fis.read(this.buff);
        this.CountryFlag = this.buff[0] < 0 ? 256 + this.buff[0] : this.buff[0];
        return this.EndIP;
    }

    private long getStartIP(long RecNo) throws IOException {
        this.OffSet = this.FirstStartIP + RecNo * 7L;
        this.fis.seek(this.OffSet);
        this.buff = new byte[4];
        this.fis.read(this.buff);
        this.StartIP = this.B2L(this.buff);
        this.buff = new byte[3];
        this.fis.read(this.buff);
        this.EndIPOff = this.B2L(this.buff);
        return this.StartIP;
    }

    public String getLocal() {
        return this.LocalStr;
    }

    public String getCountry() {
        return this.Country;
    }

    public void setPath(String path) {
        this.DbPath = path;
    }

    public static void main(String[] args) throws Exception {
        long initUsedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long start = System.currentTimeMillis();
        IPParser w = new IPParser();
        w.seek("124.193.215.57");
        System.out.println(w.getCountry() + " " + w.getLocal());
        long end = System.currentTimeMillis();
        long endUsedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.out.println("time spent:" + (end - start) + " ns");
        System.out.println("memory consumes:" + (endUsedMemory - initUsedMemory));
    }
}

