/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.ip;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLEncoder;
import jmind.core.ip.Location;
import jmind.core.ip.Pin;
import org.json.JSONObject;

public class DataPreprocessor {
    public static void main(String[] args) {
        DataPreprocessor dp = new DataPreprocessor();
        if (args.length == 0) {
            args = new String[]{"\u4e2d\u56fd\u5317\u4eac\u5e02\u660c\u5e73\u533a\u56de\u9f99\u89c2\u9547", "\u5185\u8499\u53e4", "\u56de\u9f99\u89c2"};
        }
        for (String a : args) {
            System.out.println(dp.parseLocation(a).getProvince());
        }
    }

    public Location parseLocation(String address, String pin) {
        if (address == null || address.trim().isEmpty()) {
            if (pin == null || pin.trim().isEmpty()) {
                return null;
            }
            return this.parseLocationByPin(pin);
        }
        return this.parseLocation(address);
    }

    public Location parseLocation(String address) {
        Location l = new Location(address);
        System.out.println(l.getCity());
        if (l.getCity() == null) {
            try {
                l = this.parseLocationByGoogle(address);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return l;
    }

    public String fixName(String name) {
        return name.replaceAll("[\\*\\@\\$\\#]", "").trim();
    }

    public Location parseLocationByPin(String pin) {
        Pin p = new Pin();
        String d = p.getBjd(pin);
        Location l = new Location();
        if (d == null) {
            l.setProvince("\u5916\u7701\u5e02");
        } else {
            l.setCity("\u5317\u4eac");
            l.setProvince("\u5317\u4eac");
            l.setDistrict(d);
        }
        return l;
    }

    public Location parseLocationByGoogle(String address) throws Exception {
        Location l;
        address = URLEncoder.encode(address, "UTF-8");
        URL url = new URL("http://ditu.google.cn/maps/geo?q=" + address);
        BufferedReader stream = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
        StringWriter writer = new StringWriter();
        int c = 0;
        char[] buf = new char[1024];
        while ((c = stream.read(buf)) > 0) {
            writer.write(buf, 0, c);
        }
        stream.close();
        String result = writer.toString();
        JSONObject j = new JSONObject(result);
        int code = j.getJSONObject("Status").getInt("code");
        if (code == 200) {
            JSONObject p = j.getJSONArray("Placemark").getJSONObject(0);
            address = p.getString("address");
            System.out.println(address);
            l = new Location(address);
        } else {
            l = new Location(address);
        }
        return l;
    }
}

