/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.activation.URLDataSource;
import javax.imageio.ImageIO;
import jmind.base.util.FileUtil;

public class ImageUtil {
    public static void main(String[] args) {
        Image img = ImageUtil.getImage("d:/data/QQ20141218105636.jpg");
        ImageUtil.ZoomImg(img, "d:/data/1.jpg", 300.0, 400.0);
    }

    public static File save(String srcUrl, String destFile) {
        try {
            File f = new File(destFile);
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            URL url = new URL(srcUrl);
            URLDataSource uds = new URLDataSource(url);
            InputStream is = uds.getInputStream();
            FileOutputStream fos = new FileOutputStream(f);
            byte[] buff = new byte[8192];
            int read = 0;
            while ((read = is.read(buff)) > 0) {
                fos.write(buff, 0, read);
            }
            fos.close();
            is.close();
            return f;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void ZoomImg(Image src, String targetImg, double widths, double heights) {
        try {
            double a = widths / (double)src.getWidth(null);
            double b = heights / (double)src.getHeight(null);
            if (a > b) {
                a = b;
            }
            int width = (int)((double)src.getWidth(null) * a);
            int height = (int)((double)src.getHeight(null) * a);
            if (a > 1.0) {
                width = src.getWidth(null);
                height = src.getHeight(null);
                return;
            }
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.dispose();
            ImageIO.write((RenderedImage)image, FileUtil.getExtensionName((String)targetImg), new File(targetImg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cut(String img, String targetImg, int width) {
        try {
            File _file = new File(img);
            BufferedImage src = ImageIO.read(_file);
            int sourceWidth = ((Image)src).getWidth(null);
            int sourceHeight = ((Image)src).getHeight(null);
            int x = 0;
            int y = 0;
            if (sourceWidth > sourceHeight) {
                x = (sourceWidth - sourceHeight) / 2;
            } else {
                y = (sourceHeight - sourceWidth) / 2;
            }
            System.out.println(x + " " + y);
            BufferedImage image = new BufferedImage(width, width, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, x, y, width, width, null);
            g.dispose();
            ImageIO.write((RenderedImage)image, FileUtil.getExtensionName((String)targetImg), new File(targetImg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Image getImage(String img) {
        File _file = new File(img);
        try {
            BufferedImage src = ImageIO.read(_file);
            return src;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void pressImage(String pressImg, String targetImg, int x, int y) {
        try {
            File _file = new File(targetImg);
            BufferedImage src = ImageIO.read(_file);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            if (width < 300 && height < 300) {
                System.out.println("small");
                return;
            }
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            File _filebiao = new File(pressImg);
            BufferedImage src_biao = ImageIO.read(_filebiao);
            int wideth_biao = ((Image)src_biao).getWidth(null);
            int height_biao = ((Image)src_biao).getHeight(null);
            g.drawImage(src_biao, x, y, wideth_biao, height_biao, null);
            g.dispose();
            ImageIO.write((RenderedImage)image, FileUtil.getExtensionName((String)targetImg), new File(targetImg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pressImage(String pressImg, String targetImg) {
        try {
            File _file = new File(targetImg);
            BufferedImage src = ImageIO.read(_file);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            if (width < 300 && height < 300) {
                System.out.println("small");
                return;
            }
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            File _filebiao = new File(pressImg);
            BufferedImage src_biao = ImageIO.read(_filebiao);
            int wideth_biao = ((Image)src_biao).getWidth(null);
            int height_biao = ((Image)src_biao).getHeight(null);
            int x = width - wideth_biao - 10;
            int y = height - height_biao - 10;
            g.drawImage(src_biao, x, y, wideth_biao, height_biao, null);
            g.dispose();
            ImageIO.write((RenderedImage)image, FileUtil.getExtensionName((String)targetImg), new File(targetImg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pressText(String pressText, String targetImg, String fontName, int fontStyle, Color color, int fontSize, int x, int y) {
        try {
            File _file = new File(targetImg);
            BufferedImage src = ImageIO.read(_file);
            int width = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.setColor(color);
            g.setFont(new Font(fontName, fontStyle, fontSize));
            ((Graphics)g).drawString(pressText, x, y);
            g.dispose();
            ImageIO.write((RenderedImage)image, FileUtil.getExtensionName((String)targetImg), new File(targetImg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getType(String srcFileName) {
        return ImageUtil.getType(new File(srcFileName));
    }

    public static String getType(File file) {
        FileInputStream imgFile = null;
        byte[] b = new byte[10];
        int l = -1;
        try {
            imgFile = new FileInputStream(file);
            l = imgFile.read(b);
            imgFile.close();
        }
        catch (Exception e) {
            return null;
        }
        if (l == 10) {
            byte b0 = b[0];
            byte b1 = b[1];
            byte b2 = b[2];
            byte b3 = b[3];
            byte b6 = b[6];
            byte b7 = b[7];
            byte b8 = b[8];
            byte b9 = b[9];
            if (b0 == 71 && b1 == 73 && b2 == 70) {
                return "gif";
            }
            if (b0 == 66 && b1 == 77) {
                return "bmp";
            }
            if (b1 == 80 && b2 == 78 && b3 == 71) {
                return "png";
            }
            if (b6 == 74 && b7 == 70 && b8 == 73 && b9 == 70) {
                return "jpg";
            }
            if (b6 == 69 && b7 == 120 && b8 == 105 && b9 == 102) {
                return "jpg";
            }
        }
        return null;
    }

    public static void abscut(String srcImageFile, int x, int y, int destWidth, int destHeight, int finalWidth, int finalHeight) {
        try {
            BufferedImage bi = ImageIO.read(new File(srcImageFile));
            int srcWidth = bi.getWidth();
            int srcHeight = bi.getHeight();
            System.out.println("srcWidth= " + srcWidth + "\tsrcHeight= " + srcHeight);
            if (srcWidth >= destWidth && srcHeight >= destHeight) {
                Image image = bi.getScaledInstance(finalWidth, finalHeight, 1);
                CropImageFilter cropFilter = new CropImageFilter(x, y, destWidth, destHeight);
                Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropFilter));
                BufferedImage tag = new BufferedImage(destWidth, destHeight, 1);
                Graphics g = tag.getGraphics();
                g.drawImage(img, 0, 0, null);
                g.dispose();
                ImageIO.write((RenderedImage)tag, "JPEG", new File(srcImageFile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

