/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class ImageRotate {
    public static void main(String[] args) {
        String src = "d:/data/2901.jpg";
        try {
            ImageRotate.rotate(src, "d:/data/1.jpg", 90, Color.BLACK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean rotate(String src, String target, int angle) {
        try {
            BufferedImage bufferedimage = null;
            bufferedimage = ImageIO.read(new File(src));
            int w = bufferedimage.getWidth();
            int h = bufferedimage.getHeight();
            int type = bufferedimage.getColorModel().getTransparency();
            BufferedImage img = new BufferedImage(w, h, type);
            Graphics2D graphics2d = img.createGraphics();
            graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2d.rotate(Math.toRadians(angle), w / 2, h / 2);
            graphics2d.drawImage((Image)bufferedimage, 0, 0, null);
            graphics2d.dispose();
            File f = new File(target);
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            ImageIO.write((RenderedImage)img, "png", f);
            img.flush();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean rotate(String src, String target, int angle, Color bgcolor) {
        try {
            BufferedImage image = ImageIO.read(new File(src));
            int iw = image.getWidth();
            int ih = image.getHeight();
            int w = 0;
            int h = 0;
            int x = 0;
            int y = 0;
            double ang = Math.toRadians(angle);
            if (angle % 180 == 0) {
                w = iw;
                h = ih;
            } else if (angle % 90 == 0) {
                w = ih;
                h = iw;
            } else {
                int d = iw + ih;
                w = (int)((double)d * Math.abs(Math.cos(ang)));
                h = (int)((double)d * Math.abs(Math.sin(ang)));
            }
            x = w / 2 - iw / 2;
            y = h / 2 - ih / 2;
            BufferedImage rotatedImage = new BufferedImage(w, h, image.getType());
            Graphics2D gs = (Graphics2D)rotatedImage.getGraphics();
            if (bgcolor == null) {
                rotatedImage = gs.getDeviceConfiguration().createCompatibleImage(w, h, 3);
            } else {
                gs.setColor(bgcolor);
                gs.fillRect(0, 0, w, h);
            }
            AffineTransform at = new AffineTransform();
            at.rotate(ang, w / 2, h / 2);
            at.translate(x, y);
            AffineTransformOp op = new AffineTransformOp(at, 3);
            op.filter(image, rotatedImage);
            File f = new File(target);
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            ImageIO.write((RenderedImage)rotatedImage, "png", f);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

