/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.image;

import java.io.File;
import jmind.base.util.DataUtil;
import jmind.base.util.FileUtil;
import jmind.core.image.ForWinConvertCmd;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;

public class Image4Java {
    public static String imageMagickPath = "C:\\Program Files (x86)\\ImageMagick-6.7.3-Q16";
    public static boolean windows = System.getProperty("os.name").startsWith("Windows");

    public static void main(String[] args) {
        String src = "d:/data/2901.jpg";
        try {
            Image4Java.rotate(src, "d:/data/1.jpg", 270.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testCompose() {
        String uploadDir = "D:/f/\u56fe\u7247";
        String p = uploadDir + "/60";
        File[] sourcePic = new File(p).listFiles();
        String compose = Image4Java.compose(sourcePic, null, uploadDir);
        System.out.println(compose);
    }

    public static void testAddText() {
        String base = "D:/f/\u56fe\u7247/";
        String srcPath = base + "chered2.jpg";
        String newPath = base + "new.jpg";
        try {
            Image4Java.addImgText(srcPath, newPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean rotate(String src, String target, double angle) {
        IMOperation op = new IMOperation();
        op.addImage(new String[]{src});
        op.rotate(Double.valueOf(angle));
        op.addImage(new String[]{target});
        ForWinConvertCmd convert = new ForWinConvertCmd();
        try {
            convert.run((Operation)op, new Object[0]);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String compose(File[] sourcePic, String markPic, String uploadDir) {
        if (DataUtil.isEmpty((String)markPic)) {
            markPic = "/board_thumb.jpg";
        }
        String targetPic = uploadDir + "/" + System.nanoTime() + ".jpg";
        File file = new File(uploadDir + targetPic);
        FileUtil.makeDir((File)file);
        try {
            IMOperation op = new IMOperation();
            op.size(Integer.valueOf(190), Integer.valueOf(190));
            op.strip();
            op.addImage(new String[]{uploadDir + markPic});
            int i = 0;
            for (int index = 0; index < sourcePic.length && i < 9; ++index) {
                int x = i % 3;
                if (x == 1) {
                    x = 65;
                } else if (x == 2) {
                    x = 130;
                }
                int y = i / 3;
                if (y == 1) {
                    y = 65;
                } else if (y == 2) {
                    y = 130;
                }
                if (sourcePic[index].exists()) {
                    op.addImage(new String[]{sourcePic[index].toString()});
                    op.geometry(Integer.valueOf(60), Integer.valueOf(60), Integer.valueOf(x), Integer.valueOf(y));
                    op.composite();
                    ++i;
                    continue;
                }
                System.err.println(sourcePic[index].getAbsolutePath() + " not exists.");
            }
            op.interlace("plane");
            op.addImage(new String[]{targetPic});
            ForWinConvertCmd convert = new ForWinConvertCmd();
            convert.run((Operation)op, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return targetPic;
    }

    public static void cutImage(String srcPath, String newPath, int x, int y, int x1, int y1) throws Exception {
        int width = x1 - x;
        int height = y1 - y;
        IMOperation op = new IMOperation();
        op.addImage(new String[]{srcPath});
        op.crop(Integer.valueOf(width), Integer.valueOf(height), Integer.valueOf(x), Integer.valueOf(y));
        op.addImage(new String[]{newPath});
        ConvertCmd convert = new ConvertCmd();
        if (windows) {
            convert.setSearchPath(imageMagickPath);
        }
        convert.run((Operation)op, new Object[0]);
    }

    public static void cutImage(int width, int height, String srcPath, String newPath) throws Exception {
        IMOperation op = new IMOperation();
        op.addImage(new String[]{srcPath});
        op.resize(Integer.valueOf(width), Integer.valueOf(height));
        op.addImage(new String[]{newPath});
        ConvertCmd convert = new ConvertCmd();
        if (windows) {
            convert.setSearchPath(imageMagickPath);
        }
        convert.run((Operation)op, new Object[0]);
    }

    public static void cutImage(int width, String srcPath, String newPath) throws Exception {
        IMOperation op = new IMOperation();
        op.addImage(new String[]{srcPath});
        op.resize(Integer.valueOf(width), null);
        op.addImage(new String[]{newPath});
        ConvertCmd convert = new ConvertCmd();
        if (windows) {
            convert.setSearchPath(imageMagickPath);
        }
        convert.run((Operation)op, new Object[0]);
    }

    public static void addImgText(String srcPath, String newPath) throws Exception {
        IMOperation op = new IMOperation();
        op.font("\u5b8b\u4f53").gravity("northwest").pointsize(Integer.valueOf(18)).fill("red").draw("text 50,10 q.weibo.com");
        op.addImage();
        op.addImage();
        ConvertCmd convert = new ConvertCmd();
        if (windows) {
            convert.setSearchPath(imageMagickPath);
        }
        convert.run((Operation)op, new Object[]{srcPath, newPath});
    }
}

