/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.http;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import jmind.base.lang.Pair;
import jmind.base.util.AppEnvironment;
import jmind.base.util.DataUtil;
import jmind.base.util.GlobalConstants;
import jmind.core.http.HttpClient;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class PoolingHttpClient4
extends HttpClient {
    final CloseableHttpClient httpclient;

    public PoolingHttpClient4() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        SSLContext sslCtx = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslcsf = new SSLConnectionSocketFactory(sslCtx);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslcsf).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        cm.setMaxTotal(500);
        cm.setDefaultMaxPerRoute(100);
        int connectTimeout = DataUtil.toInt((String)AppEnvironment.getProperty((String)"connectTimeout", (String)"2000"));
        int socketTimeout = DataUtil.toInt((String)AppEnvironment.getProperty((String)"socketTimeout", (String)"2000"));
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
        this.httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(defaultRequestConfig).build();
        new IdleConnectionMonitorThread((HttpClientConnectionManager)cm).start();
    }

    @Override
    public String get(String url, final String code, int soTimeout) {
        long start = System.currentTimeMillis();
        String res = null;
        try {
            HttpGet httpget = new HttpGet(url);
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        return entity != null ? EntityUtils.toString((HttpEntity)entity, (String)code) : null;
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            res = (String)this.httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
            httpget.releaseConnection();
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String post(String url, String code, int timeout, List<NameValuePair> params) {
        long start = System.currentTimeMillis();
        String res = null;
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            if (params != null) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, code));
            }
            response = this.httpclient.execute((HttpUriRequest)httpPost);
            HttpEntity entity2 = response.getEntity();
            res = EntityUtils.toString((HttpEntity)entity2, (String)code);
            EntityUtils.consume((HttpEntity)entity2);
            httpPost.releaseConnection();
            this.success(start, url + "?" + params, res);
        }
        catch (Exception e) {
            this.fail(start, url + "?" + params, e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
        return res;
    }

    @Override
    public String post(String url, Map<String, ?> params, String code, int timeout) {
        ArrayList<NameValuePair> nvps = null;
        if (!DataUtil.isEmpty(params)) {
            nvps = new ArrayList<NameValuePair>();
            for (Map.Entry<String, ?> entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                nvps.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
            }
        }
        return this.post(url, code, timeout, nvps);
    }

    @Override
    public String post(String url, List<Pair<String, String>> params, String code, int timeout) {
        ArrayList<NameValuePair> nvps = null;
        if (!DataUtil.isEmpty(params)) {
            nvps = new ArrayList<NameValuePair>();
            for (Pair<String, String> entry : params) {
                nvps.add((NameValuePair)new BasicNameValuePair((String)entry.getFirst(), (String)entry.getSecond()));
            }
        }
        return this.post(url, code, timeout, nvps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postFile(String url, Map<String, ?> params, String fileName, File file, String code) {
        Charset charset = DataUtil.isEmpty((String)code) ? Charset.defaultCharset() : Charset.forName(code);
        long start = System.currentTimeMillis();
        CloseableHttpResponse response = null;
        String res = null;
        try {
            HttpPost httppost = new HttpPost(url);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(charset);
            multipartEntityBuilder.addBinaryBody(fileName, file);
            if (!DataUtil.isEmpty(params)) {
                ContentType contentType = ContentType.create((String)"text/plain", (Charset)charset);
                for (Map.Entry<String, ?> entry : params.entrySet()) {
                    multipartEntityBuilder.addTextBody(entry.getKey(), entry.getValue().toString(), contentType);
                }
            }
            httppost.setEntity(multipartEntityBuilder.build());
            response = this.httpclient.execute((HttpUriRequest)httppost);
            HttpEntity resEntity = response.getEntity();
            if (resEntity != null) {
                res = EntityUtils.toString((HttpEntity)resEntity, (Charset)charset);
                EntityUtils.consume((HttpEntity)resEntity);
            }
            httppost.releaseConnection();
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postFile(String url, Map<String, ?> params, List<Pair<String, File>> files, String code) {
        Charset charset = DataUtil.isEmpty((String)code) ? Charset.defaultCharset() : Charset.forName(code);
        long start = System.currentTimeMillis();
        String res = null;
        CloseableHttpResponse response = null;
        try {
            HttpPost httppost = new HttpPost(url);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(charset);
            for (Pair<String, File> file : files) {
                multipartEntityBuilder.addBinaryBody((String)file.getFirst(), (File)file.getSecond());
            }
            if (!DataUtil.isEmpty(params)) {
                ContentType contentType = ContentType.create((String)"text/plain", (Charset)charset);
                for (Map.Entry<String, ?> entry : params.entrySet()) {
                    multipartEntityBuilder.addTextBody(entry.getKey(), entry.getValue().toString(), contentType);
                }
            }
            httppost.setEntity(multipartEntityBuilder.build());
            response = this.httpclient.execute((HttpUriRequest)httppost);
            HttpEntity resEntity = response.getEntity();
            if (resEntity != null) {
                res = EntityUtils.toString((HttpEntity)resEntity, (Charset)charset);
                EntityUtils.consume((HttpEntity)resEntity);
            }
            httppost.releaseConnection();
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postBody(String url, String body) {
        long start = System.currentTimeMillis();
        String res = null;
        CloseableHttpResponse response = null;
        try {
            HttpEntity resEntity;
            HttpPost httppost = new HttpPost(url);
            if (!DataUtil.isEmpty((String)body)) {
                httppost.setEntity((HttpEntity)new StringEntity(body, GlobalConstants.CHARSET_UTF8));
            }
            if ((resEntity = (response = this.httpclient.execute((HttpUriRequest)httppost)).getEntity()) != null) {
                res = EntityUtils.toString((HttpEntity)resEntity, (Charset)GlobalConstants.CHARSET_UTF8);
                EntityUtils.consume((HttpEntity)resEntity);
            }
            httppost.releaseConnection();
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
        return res;
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(180000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

