/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import jmind.base.lang.Pair;
import jmind.base.util.DataUtil;
import jmind.core.http.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.util.EncodingUtil;

public class HttpClient3
extends HttpClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String url) {
        long start = System.currentTimeMillis();
        String res = null;
        GetMethod get = new GetMethod(url);
        get.setRequestHeader("Connection", "close");
        try {
            new org.apache.commons.httpclient.HttpClient().executeMethod((HttpMethod)get);
            res = get.getResponseBodyAsString();
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            get.releaseConnection();
        }
        return res;
    }

    @Override
    public String get(String url, String code, int timeout) {
        GetMethod method = new GetMethod(url);
        return this.execute(url, code, timeout, (HttpMethod)method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execute(String url, String code, int timeout, HttpMethod method) {
        if (DataUtil.isEmpty((String)code)) {
            code = "UTF-8";
        }
        long start = System.currentTimeMillis();
        String res = null;
        org.apache.commons.httpclient.HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
        method.getParams().setContentCharset(code);
        method.getParams().setUriCharset(code);
        method.setRequestHeader("Connection", "close");
        method.setRequestHeader("Accept-Charset", code);
        if (timeout > 0) {
            method.getParams().setSoTimeout(timeout);
        }
        try {
            int statusCode = httpClient.executeMethod(method);
            if (statusCode == 200) {
                res = new String(method.getResponseBody(), code);
            }
            this.success(start, url, res);
        }
        catch (Exception e) {
            this.fail(start, url, e);
        }
        finally {
            method.releaseConnection();
        }
        return res;
    }

    @Override
    public String post(String url, Map<String, ?> params, String code, int timeout) {
        PostMethod method = new PostMethod(url);
        if (!DataUtil.isEmpty(params)) {
            for (Map.Entry<String, ?> pair : params.entrySet()) {
                method.setParameter(pair.getKey(), pair.getValue().toString());
            }
        }
        return this.execute(url, code, timeout, (HttpMethod)method);
    }

    @Override
    public String post(String url, List<Pair<String, String>> params, String code, int timeout) {
        PostMethod method = new PostMethod(url);
        if (!DataUtil.isEmpty(params)) {
            for (Pair<String, String> pair : params) {
                method.setParameter((String)pair.getFirst(), (String)pair.getSecond());
            }
        }
        return this.execute(url, code, timeout, (HttpMethod)method);
    }

    @Override
    public String postFile(String url, Map<String, ?> params, String fileName, File file, String code) {
        try {
            PostMethod method = new PostMethod(url);
            int size = DataUtil.isEmpty(params) ? 1 : 1 + params.size();
            Part[] parts = new Part[size];
            parts[0] = new CustomFilePart(fileName, file, code);
            if (!DataUtil.isEmpty(params)) {
                int i = 1;
                for (Map.Entry<String, ?> pair : params.entrySet()) {
                    parts[i++] = new StringPart(pair.getKey(), pair.getValue().toString(), code);
                }
            }
            MultipartRequestEntity mre = new MultipartRequestEntity(parts, method.getParams());
            method.setRequestEntity((RequestEntity)mre);
            return this.execute(url, code, 0, (HttpMethod)method);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String postFile(String url, Map<String, ?> params, List<Pair<String, File>> files, String code) {
        try {
            int i;
            PostMethod method = new PostMethod(url);
            int size = DataUtil.isEmpty(params) ? files.size() : files.size() + params.size();
            Part[] parts = new Part[size];
            for (i = 0; i < files.size(); ++i) {
                Pair<String, File> file = files.get(i);
                parts[i] = new CustomFilePart((String)file.getFirst(), (File)file.getSecond(), code);
            }
            if (!DataUtil.isEmpty(params)) {
                i = files.size();
                for (Map.Entry<String, ?> pair : params.entrySet()) {
                    parts[i++] = new StringPart(pair.getKey(), pair.getValue().toString(), code);
                }
            }
            MultipartRequestEntity mre = new MultipartRequestEntity(parts, method.getParams());
            method.setRequestEntity((RequestEntity)mre);
            return this.execute(url, code, 0, (HttpMethod)method);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String postBody(String url, String body) {
        PostMethod method = new PostMethod(url);
        if (!DataUtil.isEmpty((String)body)) {
            try {
                StringRequestEntity entity = new StringRequestEntity(body, null, "UTF-8");
                method.setRequestEntity((RequestEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.execute(url, "UTF-8", 0, (HttpMethod)method);
    }

    class CustomFilePart
    extends FilePart {
        public CustomFilePart(String name, File file, String code) throws FileNotFoundException {
            super(name, file, null, code);
        }

        protected void sendDispositionHeader(OutputStream out) throws IOException {
            super.sendDispositionHeader(out);
            String filename = this.getSource().getFileName();
            if (filename != null) {
                out.write(EncodingUtil.getAsciiBytes((String)"; filename="));
                out.write(QUOTE_BYTES);
                out.write(EncodingUtil.getBytes((String)filename, (String)this.getCharSet()));
                out.write(QUOTE_BYTES);
            }
        }
    }
}

