/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.http;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import jmind.base.algo.atomic.StatsCounter;
import jmind.base.lang.Pair;
import jmind.base.lang.Record;
import jmind.base.util.DataUtil;
import jmind.base.util.RequestUtil;
import jmind.core.cache.support.StatsCounterCache;
import jmind.core.http.HttpClient3;
import jmind.core.http.HttpClient4;
import jmind.core.http.HttpDefault;
import jmind.core.http.PoolingHttpClient4;
import jmind.core.log.LogUtil;
import jmind.core.spring.SpringBeanLocator;
import org.slf4j.Logger;

public abstract class HttpClient {
    private final Logger logger = LogUtil.getLogger(this.getClass());
    public static final int SLOW_TIME = 200;
    private final StatsCounterCache statsCounter = new StatsCounterCache(1000);
    private static volatile HttpClient client = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClient getHttpClient() {
        if (client != null) return client;
        Class<HttpClient> clazz = HttpClient.class;
        synchronized (HttpClient.class) {
            if (client != null) return client;
            client = HttpClient.createClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    private static HttpClient createClient() {
        HttpClient client;
        try {
            Class.forName("org.apache.http.impl.client.CloseableHttpClient");
            try {
                client = new PoolingHttpClient4();
                System.out.println("org.apache.http.impl.client.CloseableHttpClient exists create PoolingHttpClient4");
            }
            catch (Exception e) {
                client = new HttpClient4();
                System.out.println("org.apache.http.impl.client.CloseableHttpClient exists create HttpClient4");
            }
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("org.apache.commons.httpclient.HttpClient");
                client = new HttpClient3();
                System.out.println("org.apache.commons.httpclient.HttpClient exists create HttpClient3");
            }
            catch (ClassNotFoundException e1) {
                client = new HttpDefault();
                System.out.println(" create HttpDefault");
            }
        }
        return client;
    }

    public StatsCounterCache getStatsCounter() {
        return this.statsCounter;
    }

    public static final String getURI(String url) {
        int i = url.indexOf("?");
        if (i > 0) {
            return url.substring(0, i);
        }
        return url;
    }

    final void success(long start, String url, String res) {
        long t = System.currentTimeMillis() - start;
        this.logger.debug("{}t={},url={},res={}", new Object[]{t > 200L ? "slow|" : "", t, url, res == null || res.length() < 500 ? res : res.substring(0, 500)});
        this.statsCounter.mustGet(HttpClient.getURI(url)).recordSuccess(start, 200);
    }

    final void fail(long start, String url, Exception e) {
        this.logger.error(url, (Throwable)e);
        StatsCounter counter = this.statsCounter.mustGet(HttpClient.getURI(url));
        counter.recordException(start);
        if (SpringBeanLocator.getInstance().containsBean("httpRecord")) {
            Record record = SpringBeanLocator.getInstance().getBean("httpRecord", Record.class);
            record.ExceptionRecord(e, new Object[]{url, counter});
        }
    }

    public static final String getHost(String url) {
        if (!DataUtil.isEmpty((String)url)) {
            try {
                URL domain = new URL(url);
                String host = domain.getHost();
                return host;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String get(String url) {
        return this.get(url, "UTF-8", 0);
    }

    public String get(String url, Map<String, ?> params) {
        String queryString = RequestUtil.toQueryString(params);
        return this.get(url + "?" + queryString);
    }

    public abstract String get(String var1, String var2, int var3);

    public String post(String url, Map<String, ?> params) {
        return this.post(url, params, "UTF-8", 0);
    }

    public abstract String post(String var1, Map<String, ?> var2, String var3, int var4);

    public abstract String post(String var1, List<Pair<String, String>> var2, String var3, int var4);

    public abstract String postBody(String var1, String var2);

    public abstract String postFile(String var1, Map<String, ?> var2, String var3, File var4, String var5);

    public abstract String postFile(String var1, Map<String, ?> var2, List<Pair<String, File>> var3, String var4);

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
    }
}

