/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.geo;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.net.URLEncoder;
import jmind.core.geo.GLocation;
import jmind.core.geo.Geo;
import jmind.core.support.HttpUtil;

public class GoogleGeo
implements Geo {
    public static void main(String[] args) {
        String lat = "39.99676822857143";
        String lon = "116.33298485714285";
        GoogleGeo geo = new GoogleGeo();
        double location = geo.getElevation(lat, lon);
        System.out.println(location);
    }

    @Override
    public GLocation getByAddress(String address, String city) {
        if (city != null) {
            address = city + address;
        }
        try {
            String url = String.format("http://ditu.google.cn/maps/geo?q=%s&output=%s&key=%s", URLEncoder.encode(address, "UTF-8"), "json", "abcdef");
            String data = HttpUtil.get(url);
            BasicDBObject jo = (BasicDBObject)JSON.parse((String)data);
            BasicDBObject place = (BasicDBObject)((BasicDBList)jo.get("Placemark")).get(0);
            GLocation gl = new GLocation();
            gl.setAddress(place.getString("address"));
            BasicDBObject area = (BasicDBObject)((DBObject)((DBObject)place.get("AddressDetails")).get("Country")).get("AdministrativeArea");
            gl.setProvince(area.getString("AdministrativeAreaName"));
            gl.setCity(((BasicDBObject)area.get("Locality")).getString("LocalityName"));
            BasicDBList coordinates = (BasicDBList)((DBObject)place.get("Point")).get("coordinates");
            gl.setLongitude((Double)coordinates.get(0));
            gl.setLatitude((Double)coordinates.get(1));
            return gl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public GLocation getByCoordinate(String latitude, String longitude) {
        try {
            String url = String.format("http://ditu.google.cn/maps/geo?output=json&key=abcdef&q=%s,%s", latitude, longitude);
            String data = HttpUtil.get(url);
            BasicDBObject jo = (BasicDBObject)JSON.parse((String)data);
            BasicDBObject place = (BasicDBObject)((BasicDBList)jo.get("Placemark")).get(0);
            GLocation gl = new GLocation();
            gl.setAddress(place.getString("address"));
            BasicDBObject area = (BasicDBObject)((DBObject)((DBObject)place.get("AddressDetails")).get("Country")).get("AdministrativeArea");
            gl.setProvince(area.getString("AdministrativeAreaName"));
            gl.setCity(((BasicDBObject)area.get("Locality")).getString("LocalityName"));
            BasicDBList coordinates = (BasicDBList)((DBObject)place.get("Point")).get("coordinates");
            gl.setLongitude((Double)coordinates.get(0));
            gl.setLatitude((Double)coordinates.get(1));
            return gl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public double getElevation(String lat, String lon) {
        String url = "http://maps.googleapis.com/maps/api/elevation/json?sensor=false&locations=" + lat + "," + lon;
        String body = HttpUtil.get(url);
        System.out.println(body);
        DBObject jo = (DBObject)JSON.parse((String)body);
        if ("ok".equalsIgnoreCase((String)jo.get("status"))) {
            BasicDBList results = (BasicDBList)jo.get("results");
            return ((BasicDBObject)results.get(0)).getDouble("elevation");
        }
        return 0.0;
    }
}

