/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.cache.xmemcached;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import jmind.base.lang.ExpireRecord;
import jmind.core.cache.xmemcached.Memcached;
import jmind.core.cache.xmemcached.Transcoder;
import net.rubyeye.xmemcached.CASOperation;
import net.rubyeye.xmemcached.Counter;
import net.rubyeye.xmemcached.GetsResponse;
import net.rubyeye.xmemcached.KeyIterator;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientStateListener;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.buffer.BufferAllocator;
import net.rubyeye.xmemcached.impl.ReconnectRequest;
import net.rubyeye.xmemcached.networking.Connector;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.CompressionMode;
import net.rubyeye.xmemcached.utils.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedImpl
implements Memcached {
    private final MemcachedClient delegate;
    private final ExpireRecord record = new ExpireRecord(300);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public MemcachedImpl(MemcachedClient client) {
        this.delegate = client;
    }

    @Override
    public long getConnectTimeout() {
        return this.delegate.getConnectTimeout();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public ExpireRecord getException() {
        return this.record;
    }

    private void err(String key, Exception e) {
        this.logger.warn(key, (Throwable)e);
        this.record.ExceptionRecord(e, new Object[]{key});
    }

    @Override
    public <T> T get(String key, long timeout, Transcoder<T> transcoder) {
        try {
            return (T)this.delegate.get(key, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.err(key, e);
            return null;
        }
    }

    @Override
    public <T> T get(String key, long timeout) {
        try {
            return (T)this.delegate.get(key, timeout);
        }
        catch (Exception e) {
            this.err(key, e);
            return null;
        }
    }

    @Override
    public <T> T get(String key, Transcoder<T> transcoder) {
        try {
            return (T)this.delegate.get(key, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.err(key, e);
            return null;
        }
    }

    @Override
    public <T> T get(String key) {
        try {
            return (T)this.delegate.get(key);
        }
        catch (Exception e) {
            this.err(key, e);
            return null;
        }
    }

    public Map<String, ?> getMulti(Collection<String> keys) {
        return this.get(keys);
    }

    public Object getCache() {
        return null;
    }

    public void clear() {
    }

    @Override
    public <T> Map<String, T> get(Collection<String> keyCollections, long opTimeout, Transcoder<T> transcoder) {
        try {
            return this.delegate.get(keyCollections, opTimeout, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> Map<String, T> get(Collection<String> keyCollections, Transcoder<T> transcoder) {
        try {
            return this.delegate.get(keyCollections, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> Map<String, T> get(Collection<String> keyCollections) {
        try {
            return this.delegate.get(keyCollections);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> Map<String, T> get(Collection<String> keyCollections, long timeout) {
        try {
            return this.delegate.get(keyCollections, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> boolean set(String key, int exp, T value, Transcoder<T> transcoder, long timeout) {
        try {
            if (value == null) {
                return false;
            }
            return this.delegate.set(key, exp, value, this.transcoder(transcoder), timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean set(String key, int exp, Object value) {
        try {
            if (value == null) {
                return false;
            }
            return this.delegate.set(key, exp, value);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    public boolean exists(String key) {
        return false;
    }

    @Override
    public boolean set(String key, Object value) {
        return this.set(key, 2592000, value);
    }

    @Override
    public boolean set(String key, int exp, Object value, long timeout) {
        try {
            if (value == null) {
                return false;
            }
            return this.delegate.set(key, exp, value, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean set(String key, int exp, T value, Transcoder<T> transcoder) {
        try {
            if (value == null) {
                return false;
            }
            return this.delegate.set(key, exp, value, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public void setWithNoReply(String key, int exp, Object value) {
        try {
            this.delegate.setWithNoReply(key, exp, value);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public <T> void setWithNoReply(String key, int exp, T value, Transcoder<T> transcoder) {
        try {
            this.delegate.setWithNoReply(key, exp, value, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public <T> boolean add(String key, int exp, T value, Transcoder<T> transcoder, long timeout) {
        try {
            return this.delegate.add(key, exp, value, this.transcoder(transcoder), timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean add(String key, int exp, Object value) {
        try {
            return this.delegate.add(key, exp, value);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean add(String key, int exp, Object value, long timeout) {
        try {
            return this.delegate.add(key, exp, value, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean add(String key, int exp, T value, Transcoder<T> transcoder) {
        try {
            return this.delegate.add(key, exp, value, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public void addWithNoReply(String key, int exp, Object value) {
        try {
            this.delegate.addWithNoReply(key, exp, value);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public <T> void addWithNoReply(String key, int exp, T value, Transcoder<T> transcoder) {
        try {
            this.delegate.addWithNoReply(key, exp, value, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public <T> boolean replace(String key, int exp, T value, Transcoder<T> transcoder, long timeout) {
        try {
            return this.delegate.replace(key, exp, value, this.transcoder(transcoder), timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean replace(String key, int exp, Object value) {
        try {
            return this.delegate.replace(key, exp, value);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean replace(String key, int exp, Object value, long timeout) {
        try {
            return this.delegate.replace(key, exp, value, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean replace(String key, int exp, T value, Transcoder<T> transcoder) {
        try {
            return this.delegate.replace(key, exp, value, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public void replaceWithNoReply(String key, int exp, Object value) {
        try {
            this.delegate.replaceWithNoReply(key, exp, value);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public <T> void replaceWithNoReply(String key, int exp, T value, Transcoder<T> transcoder) {
        try {
            this.delegate.replaceWithNoReply(key, exp, value, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public boolean append(String key, Object value) {
        try {
            return this.delegate.append(key, value);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean append(String key, Object value, long timeout) {
        try {
            return this.delegate.append(key, value, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public void appendWithNoReply(String key, Object value) {
        try {
            this.delegate.appendWithNoReply(key, value);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public boolean prepend(String key, Object value) {
        try {
            return this.delegate.prepend(key, value);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean prepend(String key, Object value, long timeout) {
        try {
            return this.delegate.prepend(key, value, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public void prependWithNoReply(String key, Object value) {
        try {
            this.delegate.prependWithNoReply(key, value);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public boolean cas(String key, int exp, Object value, long cas) {
        try {
            return this.delegate.cas(key, exp, value, cas);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(String key, int exp, T value, Transcoder<T> transcoder, long timeout, long cas) {
        try {
            return this.delegate.cas(key, exp, value, this.transcoder(transcoder), timeout, cas);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean cas(String key, int exp, Object value, long timeout, long cas) {
        try {
            return this.delegate.cas(key, exp, value, timeout, cas);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(String key, int exp, T value, Transcoder<T> transcoder, long cas) {
        try {
            return this.delegate.cas(key, exp, value, this.transcoder(transcoder), cas);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(String key, int exp, CASOperation<T> operation, Transcoder<T> transcoder) {
        try {
            return this.delegate.cas(key, exp, operation, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(String key, int exp, GetsResponse<T> getsResponse, CASOperation<T> operation, Transcoder<T> transcoder) {
        try {
            return this.delegate.cas(key, exp, getsResponse, operation);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(String key, int exp, GetsResponse<T> getsResponse, CASOperation<T> operation) {
        try {
            return this.delegate.cas(key, exp, getsResponse, operation);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(String key, GetsResponse<T> getsResponse, CASOperation<T> operation) {
        try {
            return this.delegate.cas(key, getsResponse, operation);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(String key, int exp, CASOperation<T> operation) {
        try {
            return this.delegate.cas(key, exp, operation);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> boolean cas(String key, CASOperation<T> operation) {
        try {
            return this.delegate.cas(key, operation);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> void casWithNoReply(String key, GetsResponse<T> getsResponse, CASOperation<T> operation) {
        try {
            this.delegate.casWithNoReply(key, getsResponse, operation);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public <T> void casWithNoReply(String key, int exp, GetsResponse<T> getsResponse, CASOperation<T> operation) {
        try {
            this.delegate.casWithNoReply(key, exp, getsResponse, operation);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public <T> void casWithNoReply(String key, int exp, CASOperation<T> operation) {
        try {
            this.delegate.casWithNoReply(key, exp, operation);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public <T> void casWithNoReply(String key, CASOperation<T> operation) {
        try {
            this.delegate.casWithNoReply(key, operation);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public boolean delete(String key, long opTimeout) {
        try {
            return this.delegate.delete(key, opTimeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean touch(String key, int exp, long opTimeout) {
        try {
            return this.delegate.touch(key, exp, opTimeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean touch(String key, int exp) {
        try {
            return this.delegate.touch(key, exp);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> T getAndTouch(String key, int newExp, long opTimeout) {
        try {
            return (T)this.delegate.getAndTouch(key, newExp, opTimeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> T getAndTouch(String key, int newExp) {
        try {
            return (T)this.delegate.getAndTouch(key, newExp);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<InetSocketAddress, String> getVersions() {
        try {
            return this.delegate.getVersions();
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public long incr(String key, long delta) {
        try {
            return this.delegate.incr(key, delta);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long incr(String key, long delta, long initValue) {
        try {
            return this.delegate.incr(key, delta, initValue);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long incr(String key, long delta, long initValue, long timeout) {
        try {
            return this.delegate.incr(key, delta, initValue, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long decr(String key, long delta) {
        try {
            return this.delegate.decr(key, delta);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long decr(String key, long delta, long initValue) {
        try {
            return this.delegate.decr(key, delta, initValue);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long decr(String key, long delta, long initValue, long timeout) {
        try {
            return this.delegate.decr(key, delta, initValue, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public Map<InetSocketAddress, Map<String, String>> getStats(long timeout) {
        try {
            return this.delegate.getStats(timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<InetSocketAddress, Map<String, String>> getStats() {
        try {
            return this.delegate.getStats();
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<InetSocketAddress, Map<String, String>> getStatsByItem(String itemName) {
        try {
            return this.delegate.getStatsByItem(itemName);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean delete(String key) {
        try {
            return this.delegate.delete(key);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    public Transcoder<?> getTranscoder() {
        return this.transcoder(this.delegate.getTranscoder());
    }

    @Override
    public Map<InetSocketAddress, Map<String, String>> getStatsByItem(String itemName, long timeout) {
        try {
            return this.delegate.getStatsByItem(itemName, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public long getOpTimeout() {
        return this.delegate.getOpTimeout();
    }

    @Override
    public Map<InetSocketAddress, String> getVersions(long timeout) {
        try {
            return this.delegate.getVersions(timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public Collection<InetSocketAddress> getAvaliableServers() {
        return this.delegate.getAvaliableServers();
    }

    @Override
    public void deleteWithNoReply(String key) {
        try {
            this.delegate.deleteWithNoReply(key);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public void incrWithNoReply(String key, long delta) {
        try {
            this.delegate.incrWithNoReply(key, delta);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public void decrWithNoReply(String key, long delta) {
        try {
            this.delegate.decrWithNoReply(key, delta);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public void flushAllWithNoReply(int exptime) {
        try {
            this.delegate.flushAllWithNoReply(exptime);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public void flushAll(int exptime, long timeout) {
        try {
            this.delegate.flushAll(exptime, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public void flushAllWithNoReply(InetSocketAddress address, int exptime) {
        this.flushAllWithNoReply(address, exptime);
    }

    @Override
    public void flushAll(InetSocketAddress address, long timeout, int exptime) {
        try {
            this.delegate.flushAll(address, timeout, exptime);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    @Override
    public long getHealSessionInterval() {
        return this.delegate.getHealSessionInterval();
    }

    @Override
    public Protocol getProtocol() {
        return this.delegate.getProtocol();
    }

    @Override
    public boolean isSanitizeKeys() {
        return this.delegate.isSanitizeKeys();
    }

    @Override
    public Counter getCounter(String key) {
        return this.delegate.getCounter(key);
    }

    @Override
    public Counter getCounter(String key, long initialValue) {
        return this.delegate.getCounter(key, initialValue);
    }

    @Override
    public long decr(String key, long delta, long initValue, long timeout, int exp) {
        try {
            return this.delegate.decr(key, delta, initValue, timeout, exp);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long incr(String key, long delta, long initValue, long timeout, int exp) {
        try {
            return this.delegate.incr(key, delta, initValue, timeout, exp);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    protected void setMergeFactor(int mergeFactor) {
        this.delegate.setMergeFactor(mergeFactor);
    }

    protected void setConnectTimeout(long connectTimeout) {
        this.delegate.setConnectTimeout(connectTimeout);
    }

    protected Connector getConnector() {
        return this.delegate.getConnector();
    }

    protected void setOptimizeGet(boolean optimizeGet) {
        this.delegate.setOptimizeGet(optimizeGet);
    }

    protected void setOptimizeMergeBuffer(boolean optimizeMergeBuffer) {
        this.delegate.setOptimizeMergeBuffer(optimizeMergeBuffer);
    }

    protected void addServer(String server, int port) throws IOException {
        this.delegate.addServer(server, port);
    }

    protected void addServer(InetSocketAddress inetSocketAddress) throws IOException {
        this.delegate.addServer(inetSocketAddress);
    }

    protected void addServer(String hostList) throws IOException {
        this.delegate.addServer(hostList);
    }

    protected List<String> getServersDescription() {
        return this.delegate.getServersDescription();
    }

    protected void removeServer(String hostList) {
        this.delegate.removeServer(hostList);
    }

    protected void setBufferAllocator(BufferAllocator bufferAllocator) {
        this.delegate.setBufferAllocator(bufferAllocator);
    }

    protected <T> GetsResponse<T> gets(String key, long timeout, Transcoder<T> transcoder) {
        try {
            return this.delegate.gets(key, timeout, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> GetsResponse<T> gets(String key) {
        try {
            return this.delegate.gets(key);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> GetsResponse<T> gets(String key, long timeout) {
        try {
            return this.delegate.gets(key, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    protected <T> GetsResponse<T> gets(String key, Transcoder<?> transcoder) {
        try {
            return this.delegate.gets(key, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    protected <T> Map<String, GetsResponse<T>> gets(Collection<String> keyCollections, long opTime, Transcoder<T> transcoder) {
        try {
            return this.delegate.gets(keyCollections, opTime, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> Map<String, GetsResponse<T>> gets(Collection<String> keyCollections) {
        try {
            return this.delegate.gets(keyCollections);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> Map<String, GetsResponse<T>> gets(Collection<String> keyCollections, long timeout) {
        try {
            return this.delegate.gets(keyCollections, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    protected <T> Map<String, GetsResponse<T>> gets(Collection<String> keyCollections, Transcoder<T> transcoder) {
        try {
            return this.delegate.gets(keyCollections, this.transcoder(transcoder));
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    protected boolean delete(String key, int time) {
        try {
            return this.delegate.delete(key, time);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return false;
        }
    }

    protected void flushAll() {
        try {
            this.delegate.flushAll();
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    protected void flushAllWithNoReply() {
        try {
            this.delegate.flushAllWithNoReply();
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    protected void flushAll(long timeout) {
        try {
            this.delegate.flushAll(timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    protected void flushAll(InetSocketAddress address) {
        try {
            this.delegate.flushAll(address);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    protected void flushAllWithNoReply(InetSocketAddress address) {
        try {
            this.delegate.flushAllWithNoReply(address);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    protected void flushAll(InetSocketAddress address, long timeout) {
        try {
            this.delegate.flushAll(address, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    protected void flushAll(String host) {
        try {
            this.delegate.flushAll(host);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    protected Map<String, String> stats(InetSocketAddress address) {
        try {
            return this.delegate.stats(address);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    protected Map<String, String> stats(InetSocketAddress address, long timeout) {
        try {
            return this.delegate.stats(address, timeout);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    protected void setTranscoder(Transcoder<?> transcoder) {
        this.delegate.setTranscoder(this.transcoder(transcoder));
    }

    protected void setOpTimeout(long opTimeout) {
        this.delegate.setOpTimeout(opTimeout);
    }

    protected void addServer(String server, int port, int weight) throws IOException {
        this.delegate.addServer(server, port, weight);
    }

    protected void addServer(InetSocketAddress inetSocketAddress, int weight) throws IOException {
        this.delegate.addServer(inetSocketAddress, weight);
    }

    protected void deleteWithNoReply(String key, int time) {
        try {
            this.delegate.deleteWithNoReply(key, time);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    protected void setLoggingLevelVerbosity(InetSocketAddress address, int level) {
        try {
            this.delegate.setLoggingLevelVerbosity(address, level);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    protected void setLoggingLevelVerbosityWithNoReply(InetSocketAddress address, int level) {
        try {
            this.delegate.setLoggingLevelVerbosityWithNoReply(address, level);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
        }
    }

    protected void addStateListener(MemcachedClientStateListener listener) {
        this.delegate.addStateListener(listener);
    }

    protected void removeStateListener(MemcachedClientStateListener listener) {
        this.delegate.removeStateListener(listener);
    }

    protected Collection<MemcachedClientStateListener> getStateListeners() {
        return this.delegate.getStateListeners();
    }

    protected void setHealSessionInterval(long healConnectionInterval) {
        this.delegate.setHealSessionInterval(healConnectionInterval);
    }

    protected void setPrimitiveAsString(boolean primitiveAsString) {
        this.delegate.setPrimitiveAsString(primitiveAsString);
    }

    protected void setConnectionPoolSize(int poolSize) {
        this.delegate.setConnectionPoolSize(poolSize);
    }

    protected void setEnableHeartBeat(boolean enableHeartBeat) {
        this.delegate.setEnableHeartBeat(enableHeartBeat);
    }

    protected void setSanitizeKeys(boolean sanitizeKey) {
        this.delegate.setSanitizeKeys(sanitizeKey);
    }

    protected KeyIterator getKeyIterator(InetSocketAddress address) {
        try {
            return this.delegate.getKeyIterator(address);
        }
        catch (Exception e) {
            this.logger.warn("", (Throwable)e);
            return null;
        }
    }

    protected void setAuthInfoMap(Map<InetSocketAddress, AuthInfo> map) {
        this.delegate.setAuthInfoMap(map);
    }

    protected Map<InetSocketAddress, AuthInfo> getAuthInfoMap() {
        return this.delegate.getAuthInfoMap();
    }

    protected void setName(String name) {
        this.delegate.setName(name);
    }

    protected Queue<ReconnectRequest> getReconnectRequestQueue() {
        return this.delegate.getReconnectRequestQueue();
    }

    protected void setFailureMode(boolean failureMode) {
        this.delegate.setFailureMode(failureMode);
    }

    protected boolean isFailureMode() {
        return this.delegate.isFailureMode();
    }

    protected void finalize() throws Throwable {
        System.out.println(this.getClass().getName() + " finalize");
        this.delegate.shutdown();
        super.finalize();
    }

    private <T> Transcoder<T> transcoder(net.rubyeye.xmemcached.transcoders.Transcoder<T> t) {
        if (this.delegate == null) {
            return null;
        }
        if (t instanceof Transcoder) {
            return (Transcoder)t;
        }
        return new Transcoder<T>(){
            final net.rubyeye.xmemcached.transcoders.Transcoder<T> delegate;
            {
                this.delegate = MemcachedImpl.this.delegate.getTranscoder();
            }

            @Override
            public byte[] encode(T o) {
                return this.delegate.encode(o).getData();
            }

            @Override
            public T decode(byte[] d) {
                CachedData data = new CachedData();
                data.fillData(ByteBuffer.wrap(d), 0, d.length);
                return this.delegate.decode(data);
            }
        };
    }

    private <T> net.rubyeye.xmemcached.transcoders.Transcoder<T> transcoder(final Transcoder<T> t) {
        if (t instanceof net.rubyeye.xmemcached.transcoders.Transcoder) {
            return (net.rubyeye.xmemcached.transcoders.Transcoder)t;
        }
        return new net.rubyeye.xmemcached.transcoders.Transcoder<T>(){
            private boolean packZeros = true;
            private boolean primitiveAsString = false;

            public CachedData encode(T o) {
                byte[] data = t.encode(o);
                CachedData result = new CachedData();
                result.fillData(ByteBuffer.wrap(data), 0, data.length);
                return result;
            }

            public T decode(CachedData d) {
                try {
                    Field dataField = CachedData.class.getDeclaredField("data");
                    dataField.setAccessible(true);
                    return t.decode((byte[])dataField.get(d));
                }
                catch (Exception e) {
                    MemcachedImpl.this.logger.error("", (Throwable)e);
                    return null;
                }
            }

            public void setPrimitiveAsString(boolean primitiveAsString) {
                this.primitiveAsString = primitiveAsString;
            }

            public void setPackZeros(boolean packZeros) {
                this.packZeros = packZeros;
            }

            public void setCompressionThreshold(int to) {
            }

            public boolean isPrimitiveAsString() {
                return this.primitiveAsString;
            }

            public boolean isPackZeros() {
                return this.packZeros;
            }

            public void setCompressionMode(CompressionMode arg0) {
            }
        };
    }
}

