/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.cache.support;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import jmind.base.algo.atomic.StatsCounter;

public class StatsCounterCache {
    final Cache<String, StatsCounter> cache;

    public StatsCounterCache() {
        this(3000);
    }

    public StatsCounterCache(int maxSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).softValues().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatsCounter mustGet(String k) {
        StatsCounter statsCounter = (StatsCounter)this.cache.getIfPresent((Object)k);
        if (statsCounter == null) {
            StatsCounterCache statsCounterCache = this;
            synchronized (statsCounterCache) {
                statsCounter = (StatsCounter)this.cache.getIfPresent((Object)k);
                if (statsCounter == null) {
                    statsCounter = new StatsCounter();
                    this.cache.put((Object)k, (Object)statsCounter);
                }
            }
        }
        return statsCounter;
    }

    public List<StatsCounter.SCount> stat() {
        ConcurrentMap map = this.cache.asMap();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)map.size());
        long sumSucc = 0L;
        long sumSuccTime = 0L;
        long sumException = 0L;
        long sumExcetionTime = 0L;
        long slowCount = 0L;
        for (Map.Entry entry : map.entrySet()) {
            StatsCounter.SCount counter = ((StatsCounter)entry.getValue()).snapshot();
            counter.setKey(entry.getKey());
            list.add(counter);
            sumSucc += counter.getSuccessCount();
            sumSuccTime += counter.getTotalSuccessTime();
            sumException += counter.getExceptionCount();
            sumExcetionTime += counter.getTotalExceptionTime();
            slowCount += counter.getSlowCount();
        }
        StatsCounter.SCount counter = new StatsCounter.SCount();
        counter.setKey((Object)"total");
        counter.setSuccessCount(sumSucc);
        counter.setTotalSuccessTime(sumSuccTime);
        counter.setExceptionCount(sumException);
        counter.setTotalExceptionTime(sumExcetionTime);
        counter.setSlowCount(slowCount);
        list.add(counter);
        return list;
    }
}

