/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.cache.support;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmind.base.util.CollectionUtil;
import jmind.core.cache.support.Counter;
import jmind.core.redis.Redis;

public class RedisCache
implements Counter {
    private final Redis cache;

    public RedisCache(Redis redis) {
        this.cache = redis;
    }

    public boolean set(String key, String value) {
        this.cache.set(key, value);
        return true;
    }

    public boolean set(String key, int seconds, String value) {
        this.cache.set(key, value);
        this.cache.expire(key, seconds);
        return true;
    }

    public boolean delete(String key) {
        this.cache.del(key);
        return true;
    }

    public Map<String, ?> getMulti(Collection<String> keys) {
        String[] key = CollectionUtil.toStrArray(keys);
        List<String> mget = this.cache.mget(key);
        HashMap<String, String> values = new HashMap<String, String>();
        for (int i = 0; i < key.length; ++i) {
            values.put(key[i], mget.get(i));
        }
        return values;
    }

    public Object getCache() {
        return this.cache;
    }

    public void clear() {
    }

    @Override
    public int getAndInc(String key) {
        return this.cache.incr(key).intValue() - 1;
    }

    @Override
    public int incAndGet(String key) {
        return this.cache.incr(key).intValue();
    }

    public String get(String key) {
        return this.cache.get(key);
    }

    @Override
    public int inc(String key, int vaule) {
        return this.cache.incrBy(key, vaule).intValue();
    }

    @Override
    public int decrAndGet(String key) {
        return this.cache.decr(key).intValue();
    }

    @Override
    public int getAndDecr(String key) {
        return this.decrAndGet(key) + 1;
    }

    @Override
    public int decr(String key, int value) {
        return this.cache.decrBy(key, value).intValue();
    }

    public boolean exists(String key) {
        return this.cache.exists(key);
    }

    public boolean set(String key, Object value) {
        String v = value instanceof String ? (String)value : JSON.toJSONString((Object)value);
        return this.set(key, v);
    }

    public boolean set(String key, int seconds, Object value) {
        if (value instanceof String) {
            String v = (String)value;
        } else {
            String v = JSON.toJSONString((Object)value);
        }
        return this.set(key, seconds, value);
    }
}

