/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.cache.support;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import jmind.core.cache.support.Counter;

public class LocalCounter
implements Counter {
    private final Cache<String, AtomicInteger> cache;

    public LocalCounter(int maxSize, int duration, boolean access) {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize((long)maxSize).softValues();
        this.cache = access ? builder.expireAfterAccess((long)duration, TimeUnit.MINUTES).build() : builder.expireAfterWrite((long)duration, TimeUnit.MINUTES).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicInteger mustGet(String key) {
        AtomicInteger value = (AtomicInteger)this.cache.getIfPresent((Object)key);
        if (value == null) {
            Cache<String, AtomicInteger> cache = this.cache;
            synchronized (cache) {
                value = (AtomicInteger)this.cache.getIfPresent((Object)key);
                if (value == null) {
                    value = new AtomicInteger();
                    this.cache.put((Object)key, (Object)value);
                }
            }
        }
        return value;
    }

    public boolean set(String key, Integer value) {
        this.cache.put((Object)key, (Object)new AtomicInteger(value));
        return true;
    }

    public boolean delete(String key) {
        if (this.cache.getIfPresent((Object)key) != null) {
            this.cache.invalidate((Object)key);
            return true;
        }
        return false;
    }

    public Map<String, ?> getMulti(Collection<String> keys) {
        return null;
    }

    public Integer get(String key) {
        AtomicInteger integer = (AtomicInteger)this.cache.getIfPresent((Object)key);
        return integer == null ? 0 : integer.get();
    }

    public Object getCache() {
        return this.cache;
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public int getAndInc(String key) {
        return this.mustGet(key).getAndIncrement();
    }

    @Override
    public int incAndGet(String key) {
        return this.mustGet(key).incrementAndGet();
    }

    @Override
    public int decrAndGet(String key) {
        return this.mustGet(key).decrementAndGet();
    }

    @Override
    public int getAndDecr(String key) {
        return this.mustGet(key).getAndDecrement();
    }

    @Override
    public int decr(String key, int val) {
        return this.mustGet(key).addAndGet(-val);
    }

    @Override
    public int inc(String key, int val) {
        return this.mustGet(key).addAndGet(val);
    }

    public boolean set(String key, int seconds, Integer value) {
        this.set(key, value);
        return true;
    }

    public boolean exists(String key) {
        return this.cache.getIfPresent((Object)key) != null;
    }

    public boolean set(String key, Object value) {
        return false;
    }

    public boolean set(String key, int seconds, Object value) {
        return false;
    }
}

