/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.cache.support;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jmind.base.cache.ICache;

public class GuavaCache
implements ICache {
    final Cache<String, Object> cache;

    public GuavaCache() {
        this(3000);
    }

    public GuavaCache(int maxSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).softValues().build();
    }

    public GuavaCache(int maxSize, int duration) {
        this(maxSize, duration, false);
    }

    public GuavaCache(int maxSize, int duration, boolean access) {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize((long)maxSize).softValues();
        this.cache = access ? builder.expireAfterAccess((long)duration, TimeUnit.MINUTES).build() : builder.expireAfterWrite((long)duration, TimeUnit.MINUTES).build();
    }

    public boolean set(String key, Object value) {
        if (key != null && value != null) {
            this.cache.put((Object)key, value);
        }
        return true;
    }

    public boolean set(String key, int seconds, Object value) {
        this.set(key, value);
        return true;
    }

    public boolean delete(String key) {
        if (this.cache.getIfPresent((Object)key) != null) {
            this.cache.invalidate((Object)key);
        }
        return true;
    }

    public <V> V get(String key) {
        return (V)this.cache.getIfPresent((Object)key);
    }

    public Map<String, ?> getMulti(Collection<String> keys) {
        ImmutableMap allPresent = this.cache.getAllPresent(keys);
        return allPresent;
    }

    public String toString() {
        return this.cache.asMap().toString();
    }

    public Object getCache() {
        return this.cache;
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public boolean exists(String key) {
        return this.cache.getIfPresent((Object)key) != null;
    }
}

