/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.cache.support;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jmind.base.cache.ICache;
import jmind.base.cache.LocalCache;
import jmind.base.cache.MemCache;
import jmind.core.cache.support.GuavaCache;
import jmind.core.manager.XMemCacheManager;

public class Cache {
    private final ICache guava = new GuavaCache(6000, 10, false);
    private final LocalCache PersistentCache = new LocalCache(new ConcurrentHashMap());

    private Cache() {
    }

    public static Cache getCache() {
        return Nested.instance;
    }

    public ICache getCache(ICache.Type type, String name) {
        switch (type) {
            case XMEM: {
                return (ICache)XMemCacheManager.getInstance().getResource(name);
            }
            case GUAVA: {
                return this.guava;
            }
            case PERSISTENT: {
                return this.PersistentCache;
            }
        }
        return this.guava;
    }

    public Map<String, Object> stats(MemCache cache) {
        HashMap map = Maps.newHashMap();
        Object obj = cache.getCache();
        if (obj instanceof com.google.common.cache.Cache) {
            com.google.common.cache.Cache c = (com.google.common.cache.Cache)obj;
            map.put("size", c.size());
            map.put("stats", c.stats());
        } else if (obj instanceof Map) {
            Map c = (Map)obj;
            map.put("size", c.size());
        }
        return map;
    }

    static class Nested {
        private static Cache instance = new Cache();

        Nested() {
        }
    }
}

