/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.aspect;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmind.base.util.IpUtil;
import org.perf4j.StopWatch;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class PerformanceInterceptor
extends HandlerInterceptorAdapter {
    private static ThreadLocal<StopWatch> local = new ThreadLocal();
    private final Logger switchLogger = LoggerFactory.getLogger((String)"org.perf4j.TimingLogger");

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Slf4JStopWatch stopWatch = new Slf4JStopWatch("shell");
        local.set((StopWatch)stopWatch);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        StopWatch watch = local.get();
        if (watch != null) {
            watch.stop(this.generateOperatonIdendifier(request, watch.getElapsedTime()));
            local.remove();
        }
    }

    private String generateOperatonIdendifier(HttpServletRequest request, long exeTime) {
        StringBuilder sb = new StringBuilder(64);
        String method = request.getMethod();
        sb.append(method);
        sb.append('|');
        if (this.switchLogger.isTraceEnabled()) {
            sb.append(request.getRequestURL());
            sb.append('|');
            String clientIp = IpUtil.getIp((HttpServletRequest)request);
            sb.append(clientIp);
            sb.append('|');
            sb.append(request.getHeader("User-Agent"));
        } else {
            sb.append(request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE));
        }
        if (exeTime > 400L) {
            sb.append("|SLOW");
        }
        return sb.toString();
    }
}

