/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.aspect;

import java.util.Arrays;
import java.util.LinkedHashMap;
import jmind.base.annotation.MethodMonitor;
import jmind.base.util.IpUtil;
import jmind.core.aspect.JoinPoints;
import jmind.core.log.LogUtil;
import jmind.core.manager.MongoManager;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class MethodMonitorAspect {
    @Pointcut(value="@annotation(jmind.base.annotation.MethodMonitor)")
    public void exe2() {
    }

    @Around(value="exe2()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        return this.doit(pjp);
    }

    private Object doit(ProceedingJoinPoint pjp) throws Throwable {
        long start = System.currentTimeMillis();
        MethodMonitor m = JoinPoints.getAnnotation(pjp, MethodMonitor.class);
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Object obj = pjp.proceed();
        LinkedHashMap<String, Object> arr = new LinkedHashMap<String, Object>();
        arr.put("cla", signature.getDeclaringTypeName());
        arr.put("m", signature.getName());
        arr.put("ip", IpUtil.getLocalIP());
        if (m.args()) {
            arr.put("arg", Arrays.toString(pjp.getArgs()));
        }
        if (m.value()) {
            arr.put("res", obj);
        }
        arr.put("t", (int)(System.currentTimeMillis() - start));
        if (m.store() == MethodMonitor.Store.mongodb) {
            MongoManager.getInstance().insert("stat", "Monitor", arr);
        } else {
            LogUtil.info(((Object)arr).toString());
        }
        return obj;
    }
}

