/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.test;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TestCaptcha {
    public static void main(String[] args) {
        Properties p = new Properties();
        p.put("kaptcha.border", "no");
        p.put("kaptcha.noise.color", "0,0,255");
        p.put("kaptcha.textproducer.impl", "jmind.core.captcha.MathTextCreator");
        p.put("kaptcha.obscurificator", "com.google.code.kaptcha.impl.ShadowGimpy");
        p.put("kaptcha.textproducer.font.names", "\u5b8b\u4f53,\u6977\u4f53,\u5fae\u8f6f\u96c5\u9ed1,\u534e\u6587\u5f69\u4e91");
        Config config = new Config(p);
        DefaultKaptcha kaptcha = new DefaultKaptcha();
        kaptcha.setConfig(config);
        String capText = kaptcha.createText();
        System.out.println(capText);
        BufferedImage bi = kaptcha.createImage(capText);
        try {
            ImageIO.write((RenderedImage)bi, "jpg", new FileOutputStream("/data/captcha/a.jpg"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("image/jpeg");
        DefaultKaptcha captchaProducer = new DefaultKaptcha();
        String capText = captchaProducer.createText();
        BufferedImage bi = captchaProducer.createImage(capText);
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
        try {
            out.flush();
        }
        finally {
            out.close();
        }
    }
}

