/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.test;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jmind.core.redis.SingleJedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

public class SingleJedisTest {
    static SingleJedis jedis = new SingleJedis("192.168.75.90:6779", 30, 50, 10, null);

    public static void main(String[] args) {
        System.out.println(jedis.get("abc429"));
    }

    public static void testPipeline() {
        String key = "test.p";
        Jedis j = jedis.getResource();
        jedis.del(new String[]{key});
        System.out.println("len=" + jedis.llen(key));
        long start = System.currentTimeMillis();
        Pipeline p = j.pipelined();
        for (int i = 0; i < 100; ++i) {
            p.rpush(key, new String[]{i + ".val"});
        }
        p.sync();
        System.out.println(System.currentTimeMillis() - start);
        System.out.println("len=" + jedis.llen(key));
        jedis.close((Object)jedis);
    }

    public static void testLpush() {
        String key = "test.p";
        Jedis j = jedis.getResource();
        jedis.del(new String[]{key});
        System.out.println("len=" + jedis.llen(key));
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            jedis.rpush(key, new String[]{i + ".val"});
        }
        System.out.println(System.currentTimeMillis() - start);
        System.out.println("len=" + jedis.llen(key));
        jedis.close((Object)jedis);
    }

    public void test() {
        Jedis j = jedis.getResource();
        String key = "hi123";
        String str = jedis.get(key);
        System.out.println(str);
        System.out.println("==List==");
        jedis.del(new String[]{"messages"});
        jedis.rpush("messages", new String[]{"Hello how are you?"});
        jedis.rpush("messages", new String[]{"Fine thanks. I'm having fun with redis."});
        jedis.rpush("messages", new String[]{"I should look into this NOSQL thing ASAP"});
        List values = jedis.lrange("messages", 0L, -1L);
        System.out.println(values);
        System.out.println("==Set==");
        jedis.sadd("myset", new String[]{"1"});
        jedis.sadd("myset", new String[]{"2"});
        jedis.sadd("myset", new String[]{"3"});
        jedis.sadd("myset", new String[]{"4"});
        Set setValues = jedis.smembers("myset");
        System.out.println(setValues);
        jedis.zadd("hackers", 1940.0, "Alan Kay");
        jedis.zadd("hackers", 1953.0, "Richard Stallman");
        jedis.zadd("hackers", 1965.0, "Yukihiro Matsumoto");
        jedis.zadd("hackers", 1916.0, "Claude Shannon");
        jedis.zadd("hackers", 1969.0, "Linus Torvalds");
        jedis.zadd("hackers", 1912.0, "Alan Turing");
        jedis.zrange("hackers", 0L, -1L);
        System.out.println(setValues);
        System.out.println("==Hash==");
        Map<String, String> pairs = new HashMap<String, String>();
        pairs.put("name", "Akshi");
        pairs.put("age", "2");
        pairs.put("sex", "Female");
        jedis.hmset("kid", pairs);
        values = jedis.hmget("kid", new String[]{"name", "age"});
        System.out.println(values);
        System.out.println("------------------");
        setValues = jedis.hkeys("kid");
        System.out.println(setValues);
        System.out.println("------------------");
        values = jedis.hvals("kid");
        System.out.println(values);
        System.out.println("------------------");
        pairs = jedis.hgetAll("kid");
        System.out.println(pairs);
        jedis.close((Object)jedis);
    }
}

