/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jmind.core.redis.SingleJedis;
import redis.clients.jedis.Jedis;

public class JedisLoginTest {
    SingleJedis jedisFactory = new SingleJedis("10.22.32.188:64000", 3, 50, 10, null);
    private static final String loginKey = "sc.login";

    private List<Long> toList(Set<String> set) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (String id : set) {
            list.add(Long.parseLong(id));
        }
        return list;
    }

    public List<Long> getLogin(int count) {
        Jedis jedis = this.jedisFactory.getResource();
        Set set = jedis.zrevrange(loginKey, 0L, (long)count);
        List<Long> list = this.toList(set);
        this.jedisFactory.close((Object)jedis);
        return list;
    }

    public List<Long> getLoginByDay(int date) {
        Jedis jedis = this.jedisFactory.getResource();
        long now = System.currentTimeMillis();
        Set set = jedis.zrangeByScore(loginKey, (double)(now - (long)date * 86400000L), (double)now);
        List<Long> list = this.toList(set);
        this.jedisFactory.close((Object)jedis);
        return list;
    }

    public void removeByDay(int day) {
        Jedis jedis = this.jedisFactory.getResource();
        long now = System.currentTimeMillis();
        jedis.zremrangeByScore(loginKey, 8.64E7, (double)(now - (long)day * 86400000L));
        this.jedisFactory.close((Object)jedis);
    }

    public long getLoginLen() {
        Jedis jedis = this.jedisFactory.getResource();
        Long zcard = jedis.zcard(loginKey);
        this.jedisFactory.close((Object)jedis);
        return zcard;
    }

    public static void main(String[] args) {
        JedisLoginTest test = new JedisLoginTest();
        System.out.println(test.getLoginLen());
        System.out.println(test.getLoginByDay(2).size());
    }
}

