/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.socket;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MyClient4 {
    private static final Logger logger = Logger.getLogger(MyClient4.class.getName());

    public static void main(String[] args) throws Exception {
        new Thread(new MyRunnable()).start();
    }

    private static final class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        @Override
        public void run() {
            SocketChannel socketChannel = null;
            try {
                socketChannel = SocketChannel.open();
                InetSocketAddress socketAddress = new InetSocketAddress("localhost", 10000);
                socketChannel.connect(socketAddress);
                this.sendFile(socketChannel, new File("/data/log/client_send.log"));
                this.receiveFile(socketChannel, new File("/data/log/client_receive.log"));
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    socketChannel.close();
                }
                catch (Exception exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendFile(SocketChannel socketChannel, File file) throws IOException {
            FileInputStream fis = null;
            AbstractInterruptibleChannel channel = null;
            try {
                fis = new FileInputStream(file);
                channel = fis.getChannel();
                ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
                int size = 0;
                while ((size = ((FileChannel)channel).read(buffer)) != -1) {
                    buffer.rewind();
                    buffer.limit(size);
                    socketChannel.write(buffer);
                    buffer.clear();
                }
                socketChannel.socket().shutdownOutput();
            }
            finally {
                try {
                    channel.close();
                }
                catch (Exception exception) {}
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receiveFile(SocketChannel socketChannel, File file) throws IOException {
            FileOutputStream fos = null;
            AbstractInterruptibleChannel channel = null;
            try {
                fos = new FileOutputStream(file);
                channel = fos.getChannel();
                ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
                int size = 0;
                while ((size = socketChannel.read(buffer)) != -1) {
                    buffer.flip();
                    if (size <= 0) continue;
                    buffer.limit(size);
                    ((FileChannel)channel).write(buffer);
                    buffer.clear();
                }
            }
            finally {
                try {
                    channel.close();
                }
                catch (Exception exception) {}
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

