/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.socket;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jmind.core.socket.MyRequestObject;

public class MyClient {
    private static final Logger logger = Logger.getLogger(MyClient.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 10; ++i) {
            Socket socket = null;
            GZIPOutputStream gzipos = null;
            ObjectOutputStream oos = null;
            GZIPInputStream gzipis = null;
            ObjectInputStream ois = null;
            try {
                socket = new Socket();
                InetSocketAddress socketAddress = new InetSocketAddress("localhost", 10000);
                socket.connect(socketAddress, 10000);
                socket.setSoTimeout(10000);
                gzipos = new GZIPOutputStream(socket.getOutputStream());
                oos = new ObjectOutputStream(gzipos);
                MyRequestObject user = new MyRequestObject("user_" + i, "password_" + i);
                oos.writeObject(user);
                oos.flush();
                gzipos.finish();
                gzipis = new GZIPInputStream(socket.getInputStream());
                ois = new ObjectInputStream(gzipis);
                Object obj = ois.readObject();
                if (obj == null) continue;
                user = (MyRequestObject)obj;
                System.out.println("user: " + user.getName() + "/" + user.getPassword());
                continue;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
                continue;
            }
            finally {
                try {
                    ois.close();
                }
                catch (Exception exception) {}
                try {
                    oos.close();
                }
                catch (Exception exception) {}
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

