/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.jdbc;

import com.google.common.collect.Lists;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmind.core.ip.Location;
import jmind.core.manager.JdbcManager;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

public class BatchJdbc {
    private JdbcTemplate jdbcTemplate;

    public BatchJdbc(JdbcTemplate create) {
        this.jdbcTemplate = create;
    }

    public int[] insertUsers(final List<Location> list) {
        String sql = "insert into location(address,province) values (?,?)";
        BatchPreparedStatementSetter setter = new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Location l = (Location)list.get(i);
                ps.setString(1, l.getAddress());
                ps.setString(2, l.getProvince());
            }

            public int getBatchSize() {
                return list.size();
            }
        };
        return this.jdbcTemplate.batchUpdate(sql, setter);
    }

    public void insters() {
        String sql = "insert into location(address,province) values (?,?)";
        ArrayList batchArgs = Lists.newArrayList();
        for (int i = 0; i < 5; ++i) {
            Object[] obj = new Object[]{"address_" + i, "provice_" + i};
            batchArgs.add(obj);
        }
        int[] is = this.jdbcTemplate.batchUpdate(sql, (List)batchArgs);
        System.out.println(is.length);
    }

    public void testBatchUpdate3() {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
        String insertSql = "insert into test(name) values(:myName)";
        Location model = new Location();
        model.setProvince("name5");
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])new Object[]{model, model});
        namedParameterJdbcTemplate.batchUpdate(insertSql, params);
    }

    public void testBatchUpdate5() {
        SimpleJdbcInsert insert = new SimpleJdbcInsert(this.jdbcTemplate);
        insert.withTableName("test");
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("name", "name5");
        insert.executeBatch(new Map[]{valueMap, valueMap});
    }

    public static void main(String[] args) {
        BatchJdbc test = new BatchJdbc(JdbcManager.getInstance().create("user"));
        test.insters();
    }
}

