/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.concurrent;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jmind.base.util.RandUtil;

public class ReentrantReadWriteLock2 {
    static int threads = 100;
    static final CountDownLatch latch = new CountDownLatch(threads);
    static Map<Integer, Integer> map = Maps.newHashMap();
    static CyclicBarrier barrier = new CyclicBarrier(threads);
    static Lock lock = new ReentrantReadWriteLock().readLock();

    public static void main(String[] args) {
        for (int i = 0; i < 1000; ++i) {
            map.put(i, i + 1000);
        }
        long begin = System.nanoTime();
        for (int i = 0; i < threads; ++i) {
            new Thread(new Runner2()).start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long time = System.nanoTime() - begin;
        System.out.println("time=" + time);
    }

    static Integer get(int k) {
        try {
            lock.lock();
            Thread.sleep(2L);
            Integer n = map.get(k);
            return n;
        }
        catch (Exception e) {
            Integer n = null;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    static class Runner2
    implements Runnable {
        Runner2() {
        }

        @Override
        public void run() {
            int k = RandUtil.nextInt((int)1000);
            try {
                barrier.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (BrokenBarrierException e) {
                e.printStackTrace();
            }
            if (ReentrantReadWriteLock2.get(k) - k != 1000) {
                System.err.println(k);
            }
            latch.countDown();
        }
    }
}

