/*
 * Decompiled with CFR 0.152.
 */
package jmind.core.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class ReadWriteLockSampleSupport {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private volatile boolean completed;
    private Map<String, String> cache;

    ReadWriteLockSampleSupport() {
    }

    public void initCache() {
        this.readLock.lock();
        if (!this.completed) {
            this.readLock.unlock();
            this.writeLock.lock();
            if (!this.completed) {
                this.cache = new HashMap<String, String>(32);
                this.completed = true;
            }
            this.readLock.lock();
            this.writeLock.unlock();
        }
        System.out.println("empty? " + this.cache.isEmpty());
        this.readLock.unlock();
    }

    public String get(String key) {
        this.readLock.lock();
        System.out.println(Thread.currentThread().getName() + " read.");
        this.startTheCountdown();
        try {
            String string = this.cache.get(key);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String key, String value) {
        this.writeLock.lock();
        System.out.println(Thread.currentThread().getName() + " write.");
        this.startTheCountdown();
        try {
            String string = this.cache.put(key, value);
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void startTheCountdown() {
        long diff;
        long currentTime = System.currentTimeMillis();
        while ((diff = System.currentTimeMillis() - currentTime) <= 5000L) {
        }
    }
}

