package jmind.core.taglib;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;

import jmind.base.security.Escape;
import jmind.core.support.HTMLUtil;
import jmind.base.util.DataUtil;

/**
 * xss 过滤 <m:xss var=''/>
 * @author wbxie
 * 2013-8-13
 */
public class XSSFilterTag extends SimpleTagSupport {

    private String var;
    private boolean escape = false;

    public String getVar() {
        return var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public boolean isEscape() {
        return escape;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    @Override
    public void doTag() throws JspException, IOException {
        if (DataUtil.isEmpty(var))
            return;
        if (isEscape())
            this.getJspContext().getOut().print(Escape.escape(var));
        else
            getJspContext().getOut().print(HTMLUtil.cleanAll(var));
    }

}
