package jmind.core.taglib;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Pager<T>  {
    // 当前页
    int page = 1;

    // 每页显示记录数
    int rows = 60;


    private String orderBy;
    /**
     * 数据
     */
    private List<T> result = Collections.emptyList();
    /**
     * 总数据数
     */
    private int count;

    /**
     * 总页数,即 最后一页
     */
    private int pagecount;

    /**
     * 前一页
     */
    private int prev;
    /**
     * 后一页
     */
    private int next;

    private String uri;
    private Map<String, String> query;

    public Pager() {

    }


    public Pager(final int curpage) {
        this.page = curpage;
    }

    private void calculate() {
        //总页数

        this.pagecount = (count + rows - 1) / rows;

        this.prev = this.page <= 1 ? 0 : this.page - 1;
        this.next = this.page >= this.pagecount ? 0 : this.page + 1;
    }

    public void setResult(List<T> result) {
        this.result = result;
    }

    public void setCount(int count) {
        this.count = count;
        if (count > 0)
            calculate();
    }

    public void sePage(int curpage) {
        this.page = curpage;
        calculate();
    }

    public void setPagecount(int pagecount) {
        this.pagecount = pagecount;
    }

    public void setPrev(int prev) {
        this.prev = prev;
    }

    public void setNext(int next) {
        this.next = next;
    }

    /**
     * @return result
     */
    public List<T> getResult() {
        return result;
    }

    /**
     * @return count
     */
    public int getCount() {
        return count;
    }

    /**
     * @return pagecount
     */
    public int getPagecount() {
        return pagecount;
    }

    /**
     * @return prev
     */
    public int getPrev() {
        return prev;
    }

    /**
     * @return next
     */
    public int getNext() {
        return next;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Map<String, String> getQuery() {
        return query;
    }

    public void setQuery(Map<String, String> query) {
        this.query = query;
    }


    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public String toString() {
        return "page=" + page + ",pagesize=" + rows + ",count=" + count;
    }

}
