package jmind.core.taglib;

import java.io.IOException;
import java.util.Map;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import jmind.base.util.RequestUtil;

/**
 * 基于page 的分页tag  <m:page page="${pages}" />
 * @author wbxie
 * 2014-2-19
 */
public class PageTag extends TagSupport {
    //设置左右显示页码数
    private static final int number = 10;
    private Pager<?> page;

    public Pager<?> getPage() {
        return page;
    }

    public void setPage(Pager<?> page) {
        this.page = page;
    }

    @Override
    public int doStartTag() throws JspException {
        try {
            if (page.getPagecount() > 1) {
                String tags_html = httpUri();
                pageContext.getOut().print(tags_html);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return TagSupport.EVAL_PAGE;
    }

    @Override
    public int doEndTag() throws JspException {
        this.page = null;
        return super.doEndTag();
    }

    /**
     * HTTP URI GET 方式请求调用
     * @param
     */
    String httpUri() {
        StringBuilder html = new StringBuilder();
        html.append("<div class='paddinttop page'>");
        if (page.getPage() > 1) {
            html.append("<a href='" + getPageUrl(page.getPrev()) + "' class='prev'><em>&laquo;</em></a>");
        }
        if (page.getPage() <= 1) {
            html.append("<span class='prev'><em>&laquo;</em></span>");
        }

        boolean isNext = true;
        //如果总页码在 1...?page?...pageSize 的范围内，直接全部显示（?为im2Page.numberMuch变量）
        if (page.getPagecount() < (1 + (number * 2) + 1 + 1)) {
            for (int i = 1; i <= page.getPagecount(); i++) {
                if (page.getPage() == i) {
                    html.append("<a class='default' href='javascript:;'><em>" + i + "</em></a>");
                } else {
                    html.append("<a href='" + getPageUrl(i) + "'><em>" + i + "</em></a>");
                }
            }
            isNext = false;
        }
        if (isNext) {
            //最小数（当前page-number）
            int min = 0;
            //最大数（当前page-number）
            int max = 0;
            if ((page.getPage() - number) > 0) {
                min = page.getPage() - number;
            } else {
                min = 1;
            }
            if ((page.getPage() + number) < page.getPagecount()) {
                max = page.getPage() + number;
            } else {
                max = page.getPagecount();
            }

            if (page.getPage() <= (number - 1)) {
                max = number + 1;
            } else {
                if ((page.getPage() - 1) < number) {
                    max = max + number;
                }
                if ((page.getPage() - 1) == number) {
                    max = max + (number - 1);
                }
            }

            if (page.getPagecount() == page.getPage()) {
                min = min - number;
            }
            if ((page.getPagecount() - page.getPage()) < (number)) {
                min = min - (page.getPagecount() - page.getPage()) - 1;
            }
            if ((page.getPagecount() - page.getPage()) == (number)) {
                min = min - (number - 1);
            }

            if (min > 1) {
                html.append("<a href='" + getPageUrl(1) + "'><em>1</em></a>");
            }
            if ((min - 1) > 1) {
                html.append("&nbsp;...&nbsp;");
            }
            for (int i = min; i <= max; i++) {
                if (page.getPage() == i) {
                    html.append("<a class='default' href='javascript:;'><em>" + i + "</em></a>");
                } else {
                    html.append("<a href='" + getPageUrl(i) + "'><em>" + i + "</em></a>");
                }
            }
            if ((max + 1) < page.getPagecount()) {
                html.append("&nbsp;...&nbsp;");
            }
            if (max < page.getPagecount()) {
                html.append("<a href='" + getPageUrl(page.getPagecount()) + "'><em>" + page.getPagecount()
                        + "</em></a>");
            }
        }
        if (page.getPage() < page.getPagecount()) {
            html.append("<a href='" + getPageUrl(page.getNext()) + "' class='next'><em>&raquo;</em></a>");
        }
        if (page.getPage() >= page.getPagecount()) {
            html.append("<span class='next'><em>&raquo;</em></span>");
        }
        html.append("</div>");
        return html.toString();
    }

    private String getPageUrl(int curpage) {
        Map<String, String> query = page.getQuery();
        query.put("page", String.valueOf(curpage));
        query.put("count", String.valueOf(page.getCount()));
        // url.replaceFirst("page=\\d+", "page="+curpage)
        return page.getUri() + "?" + RequestUtil.toQueryString(query);
    }

}
