package jmind.core.taglib;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import jmind.base.util.DataUtil;

/**
 * 普通前端分页tag
 * @author wbxie  
 * <m:page  uri="" page=1 pagecount=10 count=100 />
 * 2013-8-13
 */
public class PageHtml extends TagSupport {
    private static final long serialVersionUID = 1L;

    //设置左右显示页码数
    private static final int number = 10;
    //请求URI,格式如：/user/message
    private String uri;
    //总页码
    private Integer pagecount;
    //当前页面
    private Integer page = 1;
    // 总条数
    private Integer count;

    //其他参数
    private String param;

    @Override
    public void release() {
        super.release();
    }

    @Override
    public int doStartTag() throws JspException {
        if (!DataUtil.isEmpty(uri)) {
            String tags_html = null;
            if (uri.toLowerCase().startsWith("javascript")) {
                //取消javascript
                uri = uri.substring(10, uri.length());
                if (uri.startsWith(":")) {
                    uri = uri.substring(1, uri.length());
                }
                if (!DataUtil.isEmpty(param)) {
                    tags_html = ajaxUri();
                }
            } else {
                tags_html = httpUri();
            }
            try {
                pageContext.getOut().print(tags_html);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return TagSupport.EVAL_PAGE;
    }

    /**
     * AJAX调用
     * @param html
     */
    String ajaxUri() {
        StringBuilder html = new StringBuilder();
        html.append("<script type='text/javascript'>");
        html.append("im2Page.pageSize = " + this.pagecount + ";");
        html.append("im2Page.divId = '" + param + "';");
        html.append("im2Page.number = " + number + ";");

        html.append("im2Page.pageHtml(" + this.page + ");");
        html.append("</script>");
        return html.toString();
    }

    /**
     * HTTP URI GET 方式请求调用
     * @param html
     */
    String httpUri() {
        StringBuilder html = new StringBuilder();
        html.append("<div class='paddinttop page'>");
        if (page > 1) {
            html.append("<a href='" + uri + "/" + (page - 1) + getParams() + "' class='prev'><em>&laquo;</em></a>");
        }
        if (page <= 1) {
            html.append("<span class='prev'><em>&laquo;</em></span>");
        }

        boolean isNext = true;
        //如果总页码在 1...?page?...pageSize 的范围内，直接全部显示（?为im2Page.numberMuch变量）
        if (pagecount < (1 + (number * 2) + 1 + 1)) {
            for (int i = 1; i <= pagecount; i++) {
                if (page == i) {
                    html.append("<a class='default' href='javascript:;'><em>" + i + "</em></a>");
                } else {
                    html.append("<a href='" + uri + "/" + i + getParams() + "'><em>" + i + "</em></a>");
                }
            }
            isNext = false;
        }
        if (isNext) {

            //最小数（当前page-number）
            int min = 0;
            //最大数（当前page-number）
            int max = 0;

            if ((page - number) > 0) {
                min = page - number;
            } else {
                min = 1;
            }
            if ((page + number) < pagecount) {
                max = page + number;
            } else {
                max = pagecount;
            }

            if (page <= (number - 1)) {
                max = number + 1;
            } else {
                if ((page - 1) < number) {
                    max = max + number;
                }
                if ((page - 1) == number) {
                    max = max + (number - 1);
                }
            }

            if (pagecount == page) {
                min = min - number;
            }
            if ((pagecount - page) < (number)) {
                min = min - (pagecount - page) - 1;
            }
            if ((pagecount - page) == (number)) {
                min = min - (number - 1);
            }

            if (min > 1) {
                html.append("<a href='" + uri + "/1" + getParams() + "'><em>1</em></a>");
            }
            if ((min - 1) > 1) {
                html.append("&nbsp;...&nbsp;");
            }
            for (int i = min; i <= max; i++) {
                if (page == i) {
                    html.append("<a class='default' href='javascript:;'><em>" + i + "</em></a>");
                } else {
                    html.append("<a href='" + uri + "/" + i + getParams() + "'><em>" + i + "</em></a>");
                }
            }
            if ((max + 1) < pagecount) {
                html.append("&nbsp;...&nbsp;");
            }
            if (max < pagecount) {
                html.append("<a href='" + uri + "/" + pagecount + getParams() + "'><em>" + pagecount + "</em></a>");
            }
        }
        if (page < pagecount) {
            html.append("<a href='" + uri + "/" + (page + 1) + getParams() + "' class='next'><em>&raquo;</em></a>");
        }
        if (page >= pagecount) {
            html.append("<span class='next'><em>&raquo;</em></span>");
        }
        html.append("</div>");
        return html.toString();
    }

    private String getParams() {
        if (count != null)
            return "?count=" + count;
        return DataUtil.EMPTY;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String sendUri) {
        this.uri = sendUri;
    }

    public Integer getPagecount() {
        return pagecount;
    }

    public void setPagecount(Integer pagecount) {
        this.pagecount = pagecount;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

}
